/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_239;
import net.minecraft.class_746;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class ItemSwingEffect
extends EntityEffectBase {
    private final IItemLibrary itemLibrary;
    private boolean isSwinging;

    public ItemSwingEffect(IItemLibrary itemLibrary) {
        this.itemLibrary = itemLibrary;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        boolean isTriggered;
        if (info.isRemoved()) {
            return;
        }
        class_1309 entity = info.getEntity();
        if (entity.method_5854() instanceof class_1690) {
            return;
        }
        boolean bl = isTriggered = entity.method_6055(1.0f) > 0.0f || ItemSwingEffect.looksToBeBlocking(entity);
        if (isTriggered) {
            if (!this.isSwinging) {
                Object instance;
                class_1799 currentItem = entity.field_6252 ? entity.method_5998(class_1268.field_5808) : entity.method_6030();
                Optional<ISoundFactory> factory = this.itemLibrary.getItemSwingSound(currentItem);
                if (factory.isPresent() && ItemSwingEffect.freeSwing(entity) && (instance = info.isCurrentPlayer(entity) ? factory.get().createAsAdditional() : factory.get().attachToEntity((class_1297)entity)) != null) {
                    this.playSound((class_1113)instance);
                }
                this.isSwinging = true;
            }
        } else {
            this.isSwinging = false;
        }
    }

    protected static boolean looksToBeBlocking(class_1309 entity) {
        if (!entity.method_6115() || entity.method_6030().method_7960()) {
            return false;
        }
        class_1792 item = entity.method_6030().method_7909();
        return item.method_7853(entity.method_6030()) == class_1839.field_8949;
    }

    protected static boolean freeSwing(class_1309 entity) {
        class_239 result = ItemSwingEffect.rayTraceBlock(entity);
        return result.method_17783() == class_239.class_240.field_1333;
    }

    protected static double getReach(class_1309 entity) {
        if (entity instanceof class_746) {
            class_746 p = (class_746)entity;
            return p.method_7337() ? 5.0 : 3.0;
        }
        float dist = entity.method_17681();
        dist *= 2.0f;
        dist *= dist;
        return dist += entity.method_17681();
    }

    protected static class_239 rayTraceBlock(class_1309 entity) {
        double range = ItemSwingEffect.getReach(entity);
        return entity.method_5745(range, 1.0f, true);
    }
}

