/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.lib.system.ITickCount;
import org.orecruncher.dsurround.mixinutils.ILivingEntityExtended;
import org.orecruncher.dsurround.tags.BlockEffectTags;

public class StepThroughBrushEffect
extends EntityEffectBase {
    private static final long BRUSH_INTERVAL = 2L;
    private static final class_2960 BRUSH_SOUND = class_2960.method_60655((String)"dsurround", (String)"brush_step/brush");
    private static final class_2960 STRAW_SOUND = class_2960.method_60655((String)"dsurround", (String)"brush_step/straw");
    private final ITickCount tickCount;
    private final ITagLibrary tagLibrary;
    private long lastBrushCheck;

    public StepThroughBrushEffect(ITickCount tickCount, ITagLibrary tagLibrary) {
        this.tickCount = tickCount;
        this.tagLibrary = tagLibrary;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        long currentCount = this.tickCount.getTickCount();
        if (currentCount > this.lastBrushCheck) {
            class_2338 pos;
            class_2338 feetPos;
            class_1937 world;
            this.lastBrushCheck = currentCount + 2L;
            if (info.isRemoved()) {
                return;
            }
            class_1309 entity = info.getEntity();
            if (StepThroughBrushEffect.shouldProcess(entity) && !this.process(BlockEffectTags.STRAW_STEP, STRAW_SOUND, world = entity.method_37908(), feetPos = class_2338.method_49637((double)(pos = entity.method_24515()).method_10263(), (double)((double)pos.method_10264() + 0.25), (double)pos.method_10260()))) {
                this.process(BlockEffectTags.BRUSH_STEP, BRUSH_SOUND, world, feetPos);
            }
        }
    }

    private boolean process(class_6862<class_2248> effectTag, class_2960 factory, class_1937 world, class_2338 blockPos) {
        class_2680 block = world.method_8320(blockPos);
        if (this.tagLibrary.is(effectTag, block)) {
            this.playSoundEffect(blockPos, factory, StepThroughBrushEffect.getVolumeScaling(world, blockPos, block));
            return true;
        }
        class_2338 headPos = blockPos.method_10084();
        block = world.method_8320(headPos);
        if (this.tagLibrary.is(effectTag, block)) {
            this.playSoundEffect(headPos, factory, StepThroughBrushEffect.getVolumeScaling(world, headPos, block));
            return true;
        }
        return false;
    }

    private static float getVolumeScaling(class_1937 world, class_2338 pos, class_2680 state) {
        class_265 shape = state.method_26218((class_1922)world, pos);
        return shape.method_1110() ? 1.0f : (float)shape.method_1107().field_1325;
    }

    private static boolean shouldProcess(class_1309 entity) {
        if (entity.method_5701() || entity.method_7325()) {
            return false;
        }
        if (entity.field_6212 != 0.0f || entity.field_6250 != 0.0f || entity.field_6227 != 0.0f) {
            return true;
        }
        return ((ILivingEntityExtended)entity).dsurround_isJumping();
    }

    private void playSoundEffect(class_2338 pos, class_2960 factory, float volumeScale) {
        SOUND_LIBRARY.getSoundFactory(factory).ifPresent(f -> {
            class_1109 soundInstance = f.createAtLocation(pos, volumeScale);
            this.playSound((class_1113)soundInstance);
        });
    }
}

