/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public final class ParticleRenderCollection<TParticle extends class_4003>
extends class_703 {
    private final Consumer<class_4184> setup;
    private final Supplier<class_2960> textureSupplier;
    private final ObjectArray<TParticle> particles;

    private ParticleRenderCollection(@NotNull class_638 clientLevel, @NotNull Supplier<class_2960> textureSupplier, @Nullable Consumer<class_4184> setup) {
        super(clientLevel, 0.0, 0.0, 0.0);
        this.setup = Objects.requireNonNullElseGet(setup, () -> this::standardSetup);
        this.textureSupplier = textureSupplier;
        this.particles = new ObjectArray(128);
        this.method_3070();
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public void method_3070() {
        class_243 playerPos = GameUtils.getPlayer().orElseThrow().method_33571();
        this.method_3063(playerPos.method_10216(), playerPos.method_10214(), playerPos.method_10215());
        if (!this.particles.isEmpty()) {
            this.particles.forEach(class_703::method_3070);
            this.particles.removeIf((Predicate<TParticle>)((Predicate<class_4003>)p -> !p.method_3086()));
        }
    }

    public void method_3074(@NotNull class_4588 vertexConsumer, @NotNull class_4184 camera, float tickDelta) {
        if (this.particles.isEmpty()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)this.textureSupplier.get());
        this.setup.accept(camera);
        this.particles.forEach(p -> p.method_3074(vertexConsumer, camera, tickDelta));
    }

    private void standardSetup(@NotNull class_4184 camera) {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void add(@NotNull TParticle particle) {
        if (particle.method_18122() != this.method_18122()) {
            throw new RuntimeException("Can only add render type %s particles to collection".formatted(this.method_18122()));
        }
        this.particles.add(particle);
    }

    public static final class Helper<TParticle extends class_4003> {
        private final String name;
        private final Consumer<class_4184> setup;
        private final Supplier<class_2960> textureSupplier;
        private WeakReference<ParticleRenderCollection<TParticle>> particle;
        private String diagnostics;

        public Helper(@NotNull String name, @NotNull Supplier<class_2960> textureSupplier) {
            this(name, textureSupplier, null);
        }

        public Helper(@NotNull String name, @NotNull Supplier<class_2960> textureSupplier, @Nullable Consumer<class_4184> setup) {
            this.name = name;
            this.setup = setup;
            this.textureSupplier = textureSupplier;
            this.diagnostics = this.name;
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(state -> this.clear());
            ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::collectDiagnostics);
            ClientState.TICK_END.register(this::tick);
        }

        public void add(TParticle particle) {
            this.get().add(particle);
        }

        @NotNull
        private ParticleRenderCollection<TParticle> get() {
            ParticleRenderCollection pc;
            ParticleRenderCollection particleRenderCollection = pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            if (pc == null || !pc.method_3086()) {
                pc = new ParticleRenderCollection(GameUtils.getWorld().orElseThrow(), this.textureSupplier, this.setup);
                this.particle = new WeakReference(pc);
                GameUtils.getParticleManager().method_3058(pc);
            }
            return pc;
        }

        private void clear() {
            ParticleRenderCollection pc;
            ParticleRenderCollection particleRenderCollection = pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            if (pc != null) {
                pc.method_3085();
                this.particle = null;
            }
        }

        private void tick(@NotNull class_310 client) {
            ParticleRenderCollection pc = this.particle != null ? (ParticleRenderCollection)((Object)this.particle.get()) : null;
            this.diagnostics = this.name + ": ";
            this.diagnostics = pc == null ? this.diagnostics + "Not Set" : (!pc.method_3086() ? this.diagnostics + "DEAD" : this.diagnostics + pc.particles.size());
        }

        private void collectDiagnostics(@NotNull CollectDiagnosticsEvent event) {
            event.add(CollectDiagnosticsEvent.Section.Particles, this.diagnostics);
        }
    }
}

