/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public class RandomBlockEffectSystem
extends AbstractEffectSystem {
    protected static final IRandomizer RANDOM = Randomizer.current();
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;
    private static final int ITERATION_COUNT = 667;
    private final IBlockLibrary blockLibrary;
    private final IAudioPlayer audioPlayer;
    private final int range;

    public RandomBlockEffectSystem(IModLog logger, Configuration config, IBlockLibrary blockLibrary, IAudioPlayer audioPlayer, int range) {
        super(logger, config, "Random(%d block range)".formatted(range));
        this.blockLibrary = blockLibrary;
        this.audioPlayer = audioPlayer;
        this.range = range;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void tick(Predicate<IBlockEffect> processingPredicate) {
        super.tick(processingPredicate);
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        class_1937 world = player.method_37908();
        Iterable<class_2338> iterator = this.iterateRandomly(Randomizer.current(), 667, player.method_24515(), this.range);
        for (class_2338 blockPos : iterator) {
            BlockInfo info;
            class_2680 state;
            if (this.hasSystemAtPosition(blockPos) || Constants.BLOCKS_TO_IGNORE.contains((state = world.method_8320(blockPos)).method_26204()) || !(info = this.blockLibrary.getBlockInfo(state)).hasSoundsOrEffects()) continue;
            Collection<IBlockEffectProducer> effects = info.getEffectProducers();
            if (!effects.isEmpty()) {
                for (IBlockEffectProducer be : effects) {
                    Optional<IBlockEffect> effect = be.produce(world, state, blockPos, RANDOM);
                    if (!effect.isPresent()) continue;
                    IBlockEffect e = effect.get();
                    this.systems.put(e.getPosIndex(), (Object)e);
                    break;
                }
            }
            info.getSoundToPlay(RANDOM).ifPresent(s -> {
                class_1109 instance = s.createAtLocation(blockPos);
                this.audioPlayer.play((class_1113)instance);
            });
        }
    }

    @Override
    public void blockScan(class_1937 world, class_2680 state, class_2338 pos) {
    }

    protected Iterable<class_2338> iterateRandomly(final IRandomizer random, final int count, final class_2338 center, final int range) {
        return () -> new AbstractIterator<class_2338>(this){
            final class_2338.class_2339 pos = new class_2338.class_2339();
            int remaining = count;

            protected class_2338 computeNext() {
                if (this.remaining <= 0) {
                    return (class_2338)this.endOfData();
                }
                --this.remaining;
                return this.pos.method_10103(random.triangle(center.method_10263(), range), random.triangle(center.method_10264(), range), random.triangle(center.method_10260(), range));
            }
        };
    }
}

