/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.tags.BlockEffectTags;

public class SteamEffectSystem
extends AbstractEffectSystem
implements IEffectSystem {
    public SteamEffectSystem(IModLog logger, Configuration config) {
        super(logger, config, "Steam");
    }

    @Override
    public boolean isEnabled() {
        return this.config.blockEffects.steamColumnEnabled;
    }

    @Override
    public void blockScan(class_1937 world, class_2680 state, class_2338 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (SteamEffectSystem.canSteamSpawn(world, state, pos)) {
            if (this.hasSystemAtPosition(pos)) {
                return;
            }
            SteamEffect effect = SteamEffectSystem.getSteamEffect(world, state, pos);
            this.systems.put(pos.method_10063(), (Object)effect);
        } else {
            this.blockUnscan(world, state, pos);
        }
    }

    @NotNull
    private static SteamEffect getSteamEffect(class_1937 world, class_2680 state, class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        float spawnHeight = fluidState.method_15769() ? (float)pos.method_10264() + 0.9f : (float)pos.method_10264() + fluidState.method_20785() + 0.1f;
        return new SteamEffect(world, (double)pos.method_10263() + 0.5, spawnHeight, (double)pos.method_10260() + 0.5);
    }

    private static boolean canSteamSpawn(class_1937 world, class_2680 state, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_26215() && TAG_LIBRARY.is(BlockEffectTags.STEAM_PRODUCERS, state) && BlockEffectUtils.blockExistsAround(world, pos, BlockEffectUtils.IS_HOT_SOURCE);
    }

    private static class SteamEffect
    extends AbstractParticleEmitterEffect {
        public SteamEffect(class_1937 world, double x, double y, double z) {
            super(world, x, y, z);
            this.age = RANDOM.method_43048(20);
        }

        @Override
        public boolean shouldRemove() {
            if (this.age % 10 == 0) {
                class_2680 source = this.world.method_8320(this.getPos());
                return !SteamEffectSystem.canSteamSpawn(this.world, source, this.getPos());
            }
            return false;
        }

        @Override
        protected Optional<class_703> produceParticle() {
            double VERTICAL_SPEED = 0.08;
            double JITTER = 0.4;
            boolean isSolid = this.world.method_8320(this.getPos()).method_26227().method_15769();
            double x = RANDOM.method_43385(this.posX, 0.4);
            double z = RANDOM.method_43385(this.posZ, 0.4);
            Optional<class_703> particle = this.createParticle(class_2398.field_11204, x, this.posY, z, 0.0, 0.08, 0.0);
            particle.ifPresent(p -> {
                p.method_3077(p.method_3082() * 2);
                if (isSolid) {
                    p.method_3087(0.5f);
                    p.method_34753(0.0, 0.04, 0.0);
                }
            });
            return particle;
        }
    }
}

