/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.systems;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_4066;
import net.minecraft.class_5431;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.effects.BlockEffectUtils;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IEffectSystem;
import org.orecruncher.dsurround.effects.blocks.AbstractParticleEmitterEffect;
import org.orecruncher.dsurround.effects.systems.AbstractEffectSystem;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;
import org.orecruncher.dsurround.tags.FluidTags;

public class WaterfallEffectSystem
extends AbstractEffectSystem
implements IEffectSystem {
    private static final int SOUND_CHECK_INTERVAL = 4;
    private static final int SOUND_INSTANCE_CAP = 32;
    private static final class_2382[] CARDINAL_OFFSETS = new class_2382[]{new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(0, 0, -1), new class_2382(0, 0, 1)};
    private static final ISoundFactory[] ACOUSTICS = new ISoundFactory[11];
    private final IAudioPlayer audioPlayer;
    private final Long2ObjectOpenHashMap<BackgroundSoundLoop> waterfallSoundInstances = new Long2ObjectOpenHashMap();
    private long soundCheckThrottle = 0L;

    public WaterfallEffectSystem(IModLog logger, Configuration config) {
        super(logger, config, "Waterfall");
        this.audioPlayer = ContainerManager.resolve(IAudioPlayer.class);
    }

    @Override
    public boolean isEnabled() {
        return this.config.blockEffects.waterfallsEnabled;
    }

    @Override
    public void clear() {
        super.clear();
        this.waterfallSoundInstances.values().forEach(this.audioPlayer::stop);
        this.waterfallSoundInstances.clear();
    }

    @Override
    public void tick(Predicate<IBlockEffect> processingPredicate) {
        super.tick(processingPredicate);
        if (!this.isEnabled() || !this.config.blockEffects.enableWaterfallSounds) {
            if (this.waterfallSoundInstances.isEmpty()) {
                return;
            }
            this.waterfallSoundInstances.values().forEach(this.audioPlayer::stop);
            this.waterfallSoundInstances.clear();
            return;
        }
        if (++this.soundCheckThrottle % 4L != 0L) {
            return;
        }
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        class_243 eyePosition = player.method_33571();
        Set<Long> desiredLocations = this.getDesiredWaterfallSoundLocations();
        for (IBlockEffect system : this.systems.values()) {
            long posIndex = system.getPosIndex();
            WaterfallEffect waterFallEffect = (WaterfallEffect)system;
            BackgroundSoundLoop sound2 = (BackgroundSoundLoop)((Object)this.waterfallSoundInstances.get(posIndex));
            if (desiredLocations.contains(posIndex)) {
                boolean isDone;
                if (sound2 == null) {
                    int idx = class_3532.method_15340((int)waterFallEffect.getStrength(), (int)0, (int)(ACOUSTICS.length - 1));
                    sound2 = ACOUSTICS[idx].createBackgroundSoundLoopAt(system.getPos());
                    this.waterfallSoundInstances.put(posIndex, (Object)sound2);
                }
                boolean inRange = SoundInstanceHandler.inRange(eyePosition, (class_1113)sound2, 4);
                boolean bl = isDone = !this.audioPlayer.isPlaying((class_1113)sound2);
                if (inRange && isDone) {
                    this.audioPlayer.play((class_1113)sound2);
                    continue;
                }
                if (inRange || isDone) continue;
                this.audioPlayer.stop((class_1113)sound2);
                continue;
            }
            if (sound2 == null) continue;
            this.logger.debug("[%s] removing sound instance %s", this.systemName, sound2.toString());
            this.audioPlayer.stop((class_1113)sound2);
            this.waterfallSoundInstances.remove(posIndex);
        }
        this.waterfallSoundInstances.values().removeIf(sound -> {
            if (!this.systems.containsKey(sound.getPos().method_10063())) {
                this.logger.debug("[%s] Orphan sound removed: %s", this.systemName, sound.toString());
                this.audioPlayer.stop((class_1113)sound);
                return true;
            }
            return false;
        });
    }

    protected Set<Long> getDesiredWaterfallSoundLocations() {
        if (!this.config.blockEffects.enableWaterfallSounds || this.systems.isEmpty()) {
            return ImmutableSet.of();
        }
        class_1657 player = GameUtils.getPlayer().orElseThrow();
        if (this.systems.size() <= 32) {
            return this.systems.values().stream().filter(e -> WaterfallEffectSystem.shouldPlaySoundFilter(player.method_37908(), e)).map(IBlockEffect::getPosIndex).collect(Collectors.toSet());
        }
        return this.systems.values().stream().filter(e -> WaterfallEffectSystem.shouldPlaySoundFilter(player.method_37908(), e)).map(e -> {
            WaterfallEffect effect = (WaterfallEffect)e;
            long posIndex = effect.getPosIndex();
            int strength = effect.getStrength();
            class_243 pos = effect.getPosition();
            double weight = (double)(strength * strength) / player.method_33571().method_1025(pos);
            return Pair.of((Object)weight, (Object)posIndex);
        }).sorted((e1, e2) -> -Double.compare((Double)e1.key(), (Double)e2.key())).limit(32L).map(Pair::value).collect(Collectors.toSet());
    }

    private static boolean shouldPlaySoundFilter(class_1937 world, IBlockEffect effect) {
        return TAG_LIBRARY.is(FluidTags.WATERFALL_SOUND, world.method_8316(effect.getPos()));
    }

    @Override
    public void blockScan(class_1937 world, class_2680 state, class_2338 pos) {
        if (WaterfallEffectSystem.canWaterfallSpawn(world, state, pos)) {
            if (this.hasSystemAtPosition(pos)) {
                return;
            }
            WaterfallEffect effect = WaterfallEffectSystem.createWaterfallEffect(world, state, pos);
            this.systems.put(pos.method_10063(), (Object)effect);
        } else if (this.hasSystemAtPosition(pos)) {
            this.onRemoveSystem(pos.method_10063());
        }
    }

    @Override
    protected void onRemoveSystem(long posLong) {
        super.onRemoveSystem(posLong);
        BackgroundSoundLoop sound = (BackgroundSoundLoop)((Object)this.waterfallSoundInstances.get(posLong));
        if (sound != null) {
            this.audioPlayer.stop((class_1113)sound);
            this.waterfallSoundInstances.remove(posLong);
        }
    }

    @NotNull
    private static WaterfallEffect createWaterfallEffect(class_1937 world, class_2680 state, class_2338 pos) {
        int strength = BlockEffectUtils.countVerticalBlocks(world, pos, BlockEffectUtils.HAS_FLUID, 1);
        float height = state.method_26227().method_15763((class_1922)world, pos) + 0.1f;
        return new WaterfallEffect(strength, world, pos, (double)height);
    }

    private static boolean canWaterfallSpawn(class_1937 world, class_2680 state, class_2338 pos) {
        return TAG_LIBRARY.is(FluidTags.WATERFALL_SOURCE, state.method_26227()) && WaterfallEffectSystem.isValidWaterfallSource(world, pos);
    }

    private static boolean isValidWaterfallSource(class_1937 world, class_2338 pos) {
        if (world.method_8316(pos.method_10084()).method_15769()) {
            return false;
        }
        if (WaterfallEffectSystem.isUnboundedLiquid(world, pos)) {
            class_2338 downPos = pos.method_10074();
            if (world.method_8320(downPos).method_30368((class_1922)world, downPos, class_2350.field_11036, class_5431.field_25822)) {
                return true;
            }
            return WaterfallEffectSystem.isBoundedLiquid(world, pos);
        }
        return false;
    }

    private static boolean isUnboundedLiquid(class_1937 provider, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2382 cardinal_offset : CARDINAL_OFFSETS) {
            class_2338.class_2339 tp = mutable.method_35831((class_2382)pos, cardinal_offset);
            class_2680 state = provider.method_8320((class_2338)tp);
            if (state.method_26215()) {
                return true;
            }
            class_3610 fluidState = state.method_26227();
            int height = fluidState.method_15761();
            if (height <= 0 || height >= 8) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundedLiquid(class_1937 provider, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2382 cardinal_offset : CARDINAL_OFFSETS) {
            class_2338.class_2339 tp = mutable.method_35831((class_2382)pos, cardinal_offset);
            class_2680 state = provider.method_8320((class_2338)tp);
            if (state.method_26215()) {
                return false;
            }
            class_3610 fluidState = state.method_26227();
            if (fluidState.method_15769()) continue;
            if (fluidState.method_28498((class_2769)class_3609.field_15902)) {
                return false;
            }
            int height = fluidState.method_15761();
            if (height <= 0 || height >= 8) continue;
            return false;
        }
        return true;
    }

    static {
        ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
        ISoundFactory factory = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/0")).orElseThrow();
        Arrays.fill(ACOUSTICS, factory);
        WaterfallEffectSystem.ACOUSTICS[2] = WaterfallEffectSystem.ACOUSTICS[3] = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/1")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[4] = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/2")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[5] = WaterfallEffectSystem.ACOUSTICS[6] = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/3")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[7] = WaterfallEffectSystem.ACOUSTICS[8] = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/4")).orElseThrow();
        WaterfallEffectSystem.ACOUSTICS[9] = WaterfallEffectSystem.ACOUSTICS[10] = soundLibrary.getSoundFactory(class_2960.method_60655((String)"dsurround", (String)"waterfalls/5")).orElseThrow();
    }

    private static class WaterfallEffect
    extends AbstractParticleEmitterEffect {
        private static final Configuration.BlockEffects CONFIG = ContainerManager.resolve(Configuration.BlockEffects.class);
        protected int particleLimit;
        protected final double deltaY;

        public WaterfallEffect(int strength, class_1937 world, class_2338 loc, double dY) {
            super(strength, world, (double)loc.method_10263() + 0.5, (double)loc.method_10264() + 0.5, (double)loc.method_10260() + 0.5, 4);
            this.deltaY = (double)loc.method_10264() + dY;
            this.setSpawnCount((int)((float)strength * 2.5f));
        }

        public void setSpawnCount(int limit) {
            this.particleLimit = class_3532.method_15340((int)limit, (int)5, (int)20);
        }

        @Override
        public boolean shouldRemove() {
            return this.age % 10 == 0 && !WaterfallEffectSystem.canWaterfallSpawn(this.world, this.world.method_8320(this.position), this.position);
        }

        private int getSplashParticleSpawnCount() {
            int count;
            class_4066 state = (class_4066)GameUtils.getGameSettings().method_42475().method_41753();
            switch (state) {
                case field_18199: {
                    int n = 0;
                    break;
                }
                case field_18197: {
                    int n = this.particleLimit;
                    break;
                }
                default: {
                    int n = count = this.particleLimit / 2;
                }
            }
            if (count < 4) {
                return count;
            }
            int x = count / 2;
            return RANDOM.method_43048(count - x) + x;
        }

        @Override
        protected void handleParticles() {
            if (!WaterfallEffect.CONFIG.enableWaterfallParticles) {
                return;
            }
            for (int i = 0; i <= this.getSplashParticleSpawnCount(); ++i) {
                this.produceParticle().ifPresent(this::addParticle);
            }
        }

        @Override
        protected Optional<class_703> produceParticle() {
            double xOffset = RANDOM.nextFloat(-1.0f, 1.0f);
            double zOffset = RANDOM.nextFloat(-1.0f, 1.0f);
            double motionStr = (double)(this.strength + 1) / 20.0;
            double motionX = xOffset * motionStr;
            double motionZ = zOffset * motionStr;
            double motionY = 0.1 + (double)RANDOM.method_43057() * motionStr;
            double posX = this.posX + xOffset;
            double posZ = this.posZ + zOffset;
            Optional<class_703> particle = this.createParticle(class_2398.field_11202, posX, this.deltaY, posZ, motionX, motionY, motionZ);
            particle.ifPresent(p -> {
                p.method_34753(motionX, motionY, motionZ);
                p.method_3077(p.method_3082() * 2);
            });
            return particle;
        }
    }
}

