/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.eventing;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2561;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.math.ITimer;

public final class CollectDiagnosticsEvent {
    private final Map<Section, Collection<class_2561>> data = new EnumMap<Section, Collection<class_2561>>(Section.class);

    public void add(ITimer timer) {
        this.add(Section.Timers, timer.toString());
    }

    public void add(Section panel, String text) {
        this.add(panel, (class_2561)class_2561.method_43470((String)text));
    }

    public void add(Section panel, class_2561 text) {
        this.getSectionText(panel).add(text);
    }

    public void clear() {
        this.data.forEach((key, value) -> value.clear());
    }

    public Collection<class_2561> getSectionText(Section section) {
        return this.data.computeIfAbsent(section, ignored -> new ObjectArray());
    }

    public static enum Section {
        Header(false),
        Systems,
        Particles,
        Timers(false),
        Environment(false),
        Emitters,
        Sounds,
        BlockView,
        FluidView,
        EntityView,
        HeldItem,
        Survey,
        Misc;

        private final boolean addHeader;

        private Section() {
            this(true);
        }

        private Section(boolean addHeader) {
            this.addHeader = addHeader;
        }

        public boolean addHeader() {
            return this.addHeader;
        }
    }
}

