/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.keyboard;

import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.Optional;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.gui.overlay.DiagnosticsOverlay;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlScreen;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.config.IConfigScreenFactoryProvider;
import org.orecruncher.dsurround.lib.config.IScreenFactory;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public class KeyBindings {
    public static final class_304 modConfigurationMenu;
    public static final class_304 individualSoundConfigBinding;
    public static final class_304 diagnosticHud;

    private static class_304 registerKeyBinding(String translationKey, int code, String category) {
        class_304 mapping = new class_304(translationKey, code, category);
        KeyMappingRegistry.register((class_304)mapping);
        return mapping;
    }

    public static void register() {
        ClientState.TICK_END.register(KeyBindings::handleMenuKeyPress);
    }

    private static void handleMenuKeyPress(class_310 client) {
        if (GameUtils.getCurrentScreen().isPresent() || GameUtils.getPlayer().isEmpty()) {
            return;
        }
        if (modConfigurationMenu.method_1436()) {
            IConfigScreenFactoryProvider provider = ContainerManager.resolve(IConfigScreenFactoryProvider.class);
            Optional<IScreenFactory<?>> factory = provider.getModConfigScreenFactory(Configuration.class);
            if (factory.isPresent()) {
                GameUtils.setScreen(factory.get().create(null));
            } else {
                Library.LOGGER.info("Configuration GUI libraries not present", new Object[0]);
            }
        }
        if (diagnosticHud.method_1436()) {
            ContainerManager.resolve(DiagnosticsOverlay.class).toggleCollection();
        }
        if (individualSoundConfigBinding.method_1436()) {
            boolean singlePlayer = GameUtils.isSinglePlayer();
            GameUtils.setScreen(new IndividualSoundControlScreen(null, singlePlayer));
            if (singlePlayer) {
                ContainerManager.resolve(IAudioPlayer.class).stopAll();
            }
        }
    }

    static {
        int modMenuKey = Platform.isModLoaded((String)"modmenu") ? class_3675.field_16237.method_1444() : 61;
        modConfigurationMenu = KeyBindings.registerKeyBinding("dsurround.text.keybind.modConfigurationMenu", modMenuKey, "dsurround.text.keybind.section");
        individualSoundConfigBinding = KeyBindings.registerKeyBinding("dsurround.text.keybind.individualSoundConfig", class_3675.field_16237.method_1444(), "dsurround.text.keybind.section");
        diagnosticHud = KeyBindings.registerKeyBinding("dsurround.text.keybind.diagnosticHud", class_3675.field_16237.method_1444(), "dsurround.text.keybind.section");
    }
}

