/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_8002;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.gui.overlay.AbstractOverlay;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.gui.ColorGradient;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.tags.ItemEffectTags;

public class ClockOverlay
extends AbstractOverlay {
    private static final int BOTTOM_OFFSET = 88;
    private final ITagLibrary tagLibrary;
    private final ISeasonalInformation seasonalInformation;
    private final Configuration config;
    private final MinecraftClock clock;
    private final ColorGradient gradient;
    private final ObjectArray<class_2561> clockDisplay = new ObjectArray(2);
    private boolean showClock;
    private int renderWidth;
    private int renderHeight;
    private int color;

    public ClockOverlay(Configuration config, ITagLibrary tagLibrary, ISeasonalInformation seasonalInformation) {
        this.tagLibrary = tagLibrary;
        this.seasonalInformation = seasonalInformation;
        this.config = config;
        this.clock = new MinecraftClock();
        this.gradient = new ColorGradient(ColorPalette.DARK_VIOLET, ColorPalette.SUN_GLOW, 180.0f);
        this.showClock = false;
    }

    @Override
    public void tick(class_310 client) {
        this.showClock = false;
        if (this.config.compassAndClockOptions.enableClock && GameUtils.isInGame()) {
            int n;
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            class_1799 mainHandItem = player.method_6047();
            class_1799 offHandItem = player.method_6079();
            this.showClock = this.doShowClock(mainHandItem) || this.doShowClock(offHandItem) || this.doShowClock(GameUtils.getMC().field_1692);
            this.clock.update(player.method_37908());
            this.clockDisplay.clear();
            this.clockDisplay.add(this.clock.getFormattedTime());
            this.seasonalInformation.getCurrentSeasonTranslated().ifPresent(this.clockDisplay::add);
            class_327 textRender = GameUtils.getTextRenderer();
            this.renderWidth = textRender.method_27525((class_5348)this.clockDisplay.get(0));
            if (this.clockDisplay.size() > 1) {
                this.renderWidth = Math.max(this.renderWidth, textRender.method_27525((class_5348)this.clockDisplay.get(1)));
            }
            if (this.clockDisplay.size() == 1) {
                Objects.requireNonNull(textRender);
                n = 9 - 2;
            } else {
                Objects.requireNonNull(textRender);
                n = 9 * 2;
            }
            this.renderHeight = n;
            class_1937 world = player.method_37908();
            float angleDegrees = world.method_30274(1.0f) * 360.0f + 180.0f;
            if (angleDegrees >= 360.0f) {
                angleDegrees -= 360.0f;
            }
            if (angleDegrees >= 180.0f) {
                angleDegrees = 360.0f - angleDegrees;
            }
            this.color = this.gradient.getRGBColor(angleDegrees);
        }
    }

    private boolean doShowClock(class_1799 stack) {
        return this.tagLibrary.is(ItemEffectTags.CLOCKS, stack);
    }

    private boolean doShowClock(class_1297 entity) {
        if (entity instanceof class_1533) {
            class_1533 frame = (class_1533)entity;
            class_1799 itemInFrame = frame.method_6940();
            return this.doShowClock(itemInFrame);
        }
        return false;
    }

    @Override
    public void render(class_332 context, float partialTick) {
        if (!this.showClock) {
            return;
        }
        class_327 textRender = GameUtils.getTextRenderer();
        int x = context.method_51421() / 2;
        int y = context.method_51443() - 88;
        if (this.clockDisplay.size() == 2) {
            Objects.requireNonNull(textRender);
            y -= 9 / 2;
        }
        class_8002.method_47946((class_332)context, (int)(x - this.renderWidth / 2), (int)y, (int)this.renderWidth, (int)this.renderHeight, (int)0);
        context.method_27534(textRender, this.clockDisplay.get(0), x, y, this.color);
        if (this.clockDisplay.size() == 2) {
            Objects.requireNonNull(textRender);
            context.method_27534(textRender, this.clockDisplay.get(1), x, y + 9, this.color);
        }
    }
}

