/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IDimensionInformation;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.gui.overlay.AbstractOverlay;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.tags.ItemEffectTags;

public class CompassOverlay
extends AbstractOverlay {
    private static final int CROSSHAIR_OFFSET = 60;
    private static final int TEXTURE_SIZE = 512;
    private static final float BAND_WIDTH = 130.0f;
    private static final float BAND_HEIGHT = 24.0f;
    private static final float TEXTURE_SIZE_F = 512.0f;
    private static final int HALF_TEXTURE_SIZE = 256;
    private static final class_2960 COMPASS_TEXTURE = class_2960.method_60655((String)"dsurround", (String)"textures/compass.png");
    private final ITagLibrary tagLibrary;
    private final IDimensionInformation dimensionInformation;
    private final Configuration config;
    private final CompassWobble wobbler;
    private boolean showCompass;
    private boolean spinRandomly;
    private float scale;
    private float spriteOffset;

    public CompassOverlay(Configuration config, ITagLibrary tagLibrary, IDimensionInformation dimensionInformation) {
        this.tagLibrary = tagLibrary;
        this.dimensionInformation = dimensionInformation;
        this.config = config;
        this.wobbler = new CompassWobble();
        this.showCompass = false;
        this.spriteOffset = this.config.compassAndClockOptions.compassStyle.getSpriteNumber();
        this.scale = (float)this.config.compassAndClockOptions.scale;
    }

    @Override
    public void tick(class_310 client) {
        this.showCompass = false;
        if (this.config.compassAndClockOptions.enableCompass && GameUtils.isInGame()) {
            this.scale = (float)this.config.compassAndClockOptions.scale;
            this.spriteOffset = this.config.compassAndClockOptions.compassStyle.getSpriteNumber();
            class_1657 player = GameUtils.getPlayer().orElseThrow();
            class_1799 mainHandItem = player.method_6047();
            class_1799 offHandItem = player.method_6079();
            boolean mainHandShow = this.doShowCompass(mainHandItem);
            boolean offHandShow = this.doShowCompass(offHandItem);
            boolean bl = this.showCompass = mainHandShow || offHandShow;
            if (mainHandShow) {
                this.spinRandomly = this.doCompassSpin(mainHandItem);
            }
            if (offHandShow && !this.spinRandomly) {
                this.spinRandomly = this.doCompassSpin(offHandItem);
            }
            this.wobbler.update(player.method_37908().method_8510());
        }
    }

    private boolean doShowCompass(class_1799 stack) {
        return this.tagLibrary.is(ItemEffectTags.COMPASSES, stack);
    }

    private boolean doCompassSpin(class_1799 stack) {
        return this.dimensionInformation.getCompassWobble() && this.tagLibrary.is(ItemEffectTags.COMPASS_WOBBLE, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(class_332 context, float partialTick) {
        if (!this.showCompass) {
            return;
        }
        class_4587 matrixStack = context.method_51448();
        try {
            float rotation;
            matrixStack.method_22903();
            if (this.spinRandomly) {
                rotation = this.wobbler.getRandomlySpinningRotation(partialTick);
            } else {
                class_1657 player = GameUtils.getPlayer().orElseThrow();
                rotation = player.method_5705(partialTick);
            }
            int direction = class_3532.method_15357((double)((double)(rotation * 512.0f / 360.0f) + 0.5)) & 0x1FF;
            float x = ((float)context.method_51421() - 130.0f * this.scale) / 2.0f;
            float y = ((float)(context.method_51443() - 60) - 24.0f * this.scale) / 2.0f;
            matrixStack.method_22905(this.scale, this.scale, 0.0f);
            x /= this.scale;
            y /= this.scale;
            float v = this.spriteOffset * 48.0f;
            if (direction >= 256) {
                direction -= 256;
                v += 24.0f;
            }
            this.drawTexture(matrixStack, COMPASS_TEXTURE, x, y, direction, v, 130.0f, 24.0f);
        }
        finally {
            matrixStack.method_22909();
        }
    }

    public void drawTexture(class_4587 stack, class_2960 texture, float x, float y, float u, float v, float width, float height) {
        this.drawTexture(stack, texture, x, x + width, y, y + height, width, height, u, v);
    }

    void drawTexture(class_4587 stack, class_2960 texture, float x1, float x2, float y1, float y2, float regionWidth, float regionHeight, float u, float v) {
        this.drawTexturedQuad(stack, texture, x1, x2, y1, y2, 0.0f, u / 512.0f, (u + regionWidth) / 512.0f, v / 512.0f, (v + regionHeight) / 512.0f);
    }

    void drawTexturedQuad(class_4587 stack, class_2960 texture, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = stack.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, x1, y1, z).method_22913(u1, v1);
        bufferBuilder.method_22918(matrix4f, x1, y2, z).method_22913(u1, v2);
        bufferBuilder.method_22918(matrix4f, x2, y2, z).method_22913(u2, v2);
        bufferBuilder.method_22918(matrix4f, x2, y1, z).method_22913(u2, v1);
        class_9801 mesh = bufferBuilder.method_60794();
        if (mesh != null) {
            class_286.method_43433((class_9801)mesh);
        }
    }

    static class CompassWobble {
        private static int TICK_DELAY = 5;
        private static float MAX_DELTA_TICK = 0.05f;
        private float targetRotation;
        private float lastRotation;
        private float rotation;
        private float rotationStep;
        private long lastUpdateTick;
        private int tickWait;

        CompassWobble() {
        }

        public float getRandomlySpinningRotation(float partialTick) {
            return class_3532.method_16439((float)partialTick, (float)this.lastRotation, (float)this.rotation) * 360.0f;
        }

        public void update(long tickCount) {
            if (this.lastUpdateTick != tickCount) {
                this.updateRotation(tickCount);
            }
        }

        private void updateRotation(long tickCount) {
            this.lastUpdateTick = tickCount;
            this.lastRotation = this.rotation;
            if (this.rotation < this.targetRotation) {
                this.rotation += this.rotationStep;
                if (this.rotation > this.targetRotation) {
                    this.rotation = this.targetRotation;
                }
            } else if (this.rotation > this.targetRotation) {
                this.rotation -= this.rotationStep;
                if (this.rotation < this.targetRotation) {
                    this.rotation = this.targetRotation;
                }
            }
            if (this.rotation == this.targetRotation) {
                if (this.tickWait < 0) {
                    this.tickWait = Randomizer.current().method_43048(TICK_DELAY);
                } else if (--this.tickWait == 0) {
                    this.targetRotation = Randomizer.current().method_43057();
                    this.rotationStep = MAX_DELTA_TICK;
                }
            }
        }
    }
}

