/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay;

import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.AbstractOverlay;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.gui.overlay.plugins.ClientProfilerPlugin;
import org.orecruncher.dsurround.gui.overlay.plugins.RuntimeDiagnosticsPlugin;
import org.orecruncher.dsurround.gui.overlay.plugins.SoundEngineDiagnosticsPlugin;
import org.orecruncher.dsurround.gui.overlay.plugins.ViewerPlugin;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;
import org.orecruncher.dsurround.lib.platform.ModInformation;

public class DiagnosticsOverlay
extends AbstractOverlay {
    private static final int BACKGROUND_COLOR = -1873784752;
    private static final int FOREGROUND_COLOR = 0xE0E0E0;
    private static final class_2583 SPECIAL_MOD_STYLE = class_2583.field_24360.method_27703(ColorPalette.BRASS).method_10978(Boolean.valueOf(true));
    private static final Map<CollectDiagnosticsEvent.Section, class_5251> COLOR_MAP = new EnumMap<CollectDiagnosticsEvent.Section, class_5251>(CollectDiagnosticsEvent.Section.class);
    private static final ObjectArray<CollectDiagnosticsEvent.Section> RIGHT_SIDE_LAYOUT = new ObjectArray();
    private static final ObjectArray<CollectDiagnosticsEvent.Section> LEFT_SIDE_LAYOUT = new ObjectArray();
    private final LoggingTimerEMA diagnostics = new LoggingTimerEMA("Collect Diagnostic");
    private final LoggingTimerEMA rendering = new LoggingTimerEMA("Render Diagnostic");
    private final String branding;
    private final ObjectArray<IDiagnosticPlugin> plugins = new ObjectArray();
    private final CollectDiagnosticsEvent reusableEvent = new CollectDiagnosticsEvent();
    private final ObjectArray<class_5481> left = new ObjectArray(64);
    private final ObjectArray<class_5481> right = new ObjectArray(64);
    private boolean showHud;
    private boolean enableCollection;
    private String serverBranding;

    public DiagnosticsOverlay(ModInformation modInformation) {
        String platformName = Platform.isFabric() ? "Fabric" : "NeoForge";
        this.branding = "%s (%s)".formatted(modInformation.getBranding(), platformName);
        this.showHud = false;
        this.enableCollection = false;
        this.plugins.add(ContainerManager.resolve(ClientProfilerPlugin.class));
        this.plugins.add(ContainerManager.resolve(ViewerPlugin.class));
        this.plugins.add(ContainerManager.resolve(RuntimeDiagnosticsPlugin.class));
        this.plugins.add(ContainerManager.resolve(SoundEngineDiagnosticsPlugin.class));
    }

    public void toggleCollection() {
        this.enableCollection = !this.enableCollection;
    }

    @Override
    public void tick(class_310 client) {
        boolean bl = this.showHud = this.enableCollection && !this.isDebugHudEnabled();
        if (this.showHud) {
            this.diagnostics.begin();
            this.plugins.forEach(p -> p.tick(client));
            this.reusableEvent.clear();
            this.reusableEvent.add(CollectDiagnosticsEvent.Section.Header, this.branding);
            Optional<String> serverBrand = GameUtils.getServerBrand();
            serverBrand.ifPresent(brand -> this.reusableEvent.add(CollectDiagnosticsEvent.Section.Header, "Server Brand: %s".formatted(brand)));
            for (String modId : Constants.SPECIAL_MODS) {
                if (!Platform.isModLoaded((String)modId)) continue;
                this.reusableEvent.add(CollectDiagnosticsEvent.Section.Header, (class_2561)class_2561.method_43470((String)("MOD: " + modId)).method_27696(SPECIAL_MOD_STYLE));
            }
            this.reusableEvent.add(this.diagnostics);
            this.reusableEvent.add(this.rendering);
            ((ClientEventHooks.ICollectDiagnostics)ClientEventHooks.COLLECT_DIAGNOSTICS.raise()).onCollect(this.reusableEvent);
            this.left.clear();
            this.right.clear();
            DiagnosticsOverlay.processOutput(LEFT_SIDE_LAYOUT, this.reusableEvent, this.left);
            DiagnosticsOverlay.processOutput(RIGHT_SIDE_LAYOUT, this.reusableEvent, this.right);
            this.diagnostics.end();
        }
    }

    private static void processOutput(ObjectArray<CollectDiagnosticsEvent.Section> sections, CollectDiagnosticsEvent event, ObjectArray<class_5481> result) {
        boolean addBlankLine = false;
        for (CollectDiagnosticsEvent.Section p : sections) {
            Collection<class_2561> data = event.getSectionText(p);
            if (data.isEmpty()) continue;
            if (addBlankLine) {
                result.add(null);
            } else {
                addBlankLine = true;
            }
            class_2583 style = class_2583.field_24360.method_27703(COLOR_MAP.get((Object)p));
            if (p.addHeader()) {
                class_5481 t = class_2561.method_43470((String)p.name()).method_27696(style.method_30938(Boolean.valueOf(true))).method_30937();
                result.add(t);
            }
            for (class_2561 d : data) {
                if (d.method_10866().method_10967()) {
                    result.add(d.method_27661().method_27696(style).method_30937());
                    continue;
                }
                result.add(d.method_30937());
            }
        }
    }

    @Override
    public void render(class_332 context, float partialTick) {
        if (this.showHud) {
            this.rendering.begin();
            this.drawText(context, this.left, true);
            this.drawText(context, this.right, false);
            this.rendering.end();
        }
    }

    private boolean isDebugHudEnabled() {
        return GameUtils.isInGame() && GameUtils.getMC().method_53526().method_53536();
    }

    private void drawText(class_332 context, ObjectArray<class_5481> text, boolean left) {
        class_327 textRenderer = GameUtils.getTextRenderer();
        Objects.requireNonNull(textRenderer);
        int i = 9;
        for (int j = 0; j < text.size(); ++j) {
            class_5481 component = text.get(j);
            if (component == null) continue;
            int k = textRenderer.method_30880(component);
            int l = left ? 2 : context.method_51421() - 2 - k;
            int m = 2 + i * j;
            context.method_25294(l - 1, m - 1, l + k + 1, m + i - 1, -1873784752);
            context.method_51430(textRenderer, component, l, m, 0xE0E0E0, false);
        }
    }

    static {
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Header, ColorPalette.PUMPKIN_ORANGE);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Systems, ColorPalette.GREEN);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Particles, ColorPalette.HOT_PINK);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Timers, ColorPalette.KEY_LIME);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Environment, ColorPalette.AQUAMARINE);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Emitters, ColorPalette.SEASHELL);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Sounds, ColorPalette.APRICOT);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.HeldItem, ColorPalette.ANTIQUE_WHITE);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.BlockView, ColorPalette.BRASS);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.FluidView, ColorPalette.TURQUOISE);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.EntityView, ColorPalette.RASPBERRY);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Survey, ColorPalette.ORCHID);
        COLOR_MAP.put(CollectDiagnosticsEvent.Section.Misc, ColorPalette.GRAY);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Header);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Environment);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Systems);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Particles);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Emitters);
        LEFT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Sounds);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Timers);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Survey);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.Misc);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.HeldItem);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.BlockView);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.FluidView);
        RIGHT_SIDE_LAYOUT.add(CollectDiagnosticsEvent.Section.EntityView);
    }
}

