/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.MinecraftClock;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.lib.seasons.ISeasonalInformation;
import org.orecruncher.dsurround.mixinutils.IMusicManager;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;

public class RuntimeDiagnosticsPlugin
implements IDiagnosticPlugin {
    private static final List<String> scripts = ImmutableList.of((Object)"'Dim: ' + dim.getId() + '/' + dim.getDimName() + '; isSuperFlat: ' + dim.isSuperFlat()", (Object)"'Biome: ' + biome.getName() + ' (' + biome.getId() + '); Temp ' + biome.getTemperature() + '; rainfall: ' + biome.getRainfall()", (Object)"'Biome Traits: ' + biome.getTraits()", (Object)"'Weather: ' + lib.iif(weather.isRaining(),'rain: ' + weather.getRainIntensity(),'not raining') + lib.iif(weather.isThundering(),' thundering','') + '; Temp: ' + weather.getTemperature() + '; ice: ' + lib.iif(weather.getTemperature() < 0.15, 'true', 'false') + ' ' + lib.iif(weather.getTemperature() < 0.2, '(breath)', '')", (Object)"'Diurnal: ' + lib.iif(diurnal.isNight(),' night,',' day,') + '; celestial angle: ' + diurnal.getCelestialAngle() + '; degrees: ' + (diurnal.getCelestialAngle()*360)", (Object)"'Player: health ' + player.getHealth() + '/' + player.getMaxHealth() + '; food ' + player.getFoodLevel() + '/' + player.getFoodSaturationLevel() + '; pos (' + player.getX() + ', ' + player.getY() + ', ' + player.getZ() + ')'", (Object)"'State: isInside ' + state.isInside() + '; inVillage ' + state.isInVillage() + '; isUnderWater ' + state.isUnderWater()");
    private final MinecraftClock clock = new MinecraftClock();
    private final IConditionEvaluator conditionEvaluator;
    private final ISeasonalInformation seasonalInformation;

    public RuntimeDiagnosticsPlugin(IConditionEvaluator conditionEvaluator, ISeasonalInformation seasonalInformation) {
        this.conditionEvaluator = conditionEvaluator;
        this.seasonalInformation = seasonalInformation;
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect, HandlerPriority.HIGH);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        if (GameUtils.isInGame()) {
            class_638 world = GameUtils.getWorld().orElseThrow();
            this.clock.update((class_1937)world);
            event.add(CollectDiagnosticsEvent.Section.Header, this.clock.getFormattedTime());
            class_2561 seasonInfo = this.seasonalInformation.getCurrentSeasonTranslated().orElse((class_2561)class_2561.method_43470((String)"UNKNOWN"));
            class_5250 seasonText = class_2561.method_43469((String)"Season: %s (%s)", (Object[])new Object[]{seasonInfo, this.seasonalInformation.getProviderName()});
            event.add(CollectDiagnosticsEvent.Section.Header, (class_2561)seasonText);
            String particleLoad = "Particle Manager: %s".formatted(GameUtils.getParticleManager().method_3052());
            event.add(CollectDiagnosticsEvent.Section.Systems, particleLoad);
            String musicManager = ((IMusicManager)GameUtils.getMC().method_1538()).dsurround_getDiagnosticText();
            event.add(CollectDiagnosticsEvent.Section.Systems, musicManager);
            for (String script : scripts) {
                Object result = this.conditionEvaluator.eval(new Script(script));
                event.add(CollectDiagnosticsEvent.Section.Environment, result.toString());
            }
        }
    }
}

