/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_4235;
import net.minecraft.class_5250;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.mixins.audio.MixinSoundEngineAccessor;
import org.orecruncher.dsurround.mixins.audio.MixinSoundManagerAccessor;

public class SoundEngineDiagnosticsPlugin
implements IDiagnosticPlugin {
    private static final String FMT_DBG_SOUND = "%s: %d";

    public SoundEngineDiagnosticsPlugin() {
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect, HandlerPriority.LOW);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        class_1144 soundManager = GameUtils.getSoundManager();
        Collection<class_2561> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.Sounds);
        for (class_3419 category : class_3419.values()) {
            float volumeSettings = GameUtils.getGameSettings().method_1630(category);
            if (Float.compare(volumeSettings, 0.0f) != 0) continue;
            class_5250 text = class_2561.method_43470((String)"%s is OFF".formatted(category.name())).method_54663(ColorPalette.RED.method_27716());
            panelText.add((class_2561)text);
        }
        MixinSoundManagerAccessor manager = (MixinSoundManagerAccessor)soundManager;
        MixinSoundEngineAccessor accessors = (MixinSoundEngineAccessor)manager.dsurround_getSoundSystem();
        Map<class_1113, class_4235.class_4236> sources = accessors.dsurround_getSources();
        class_5250 str = class_2561.method_43470((String)soundManager.method_20305());
        panelText.add((class_2561)str);
        if (!sources.isEmpty()) {
            accessors.dsurround_getSources().keySet().stream().map(class_1113::method_4775).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> FMT_DBG_SOUND.formatted(e.getKey(), e.getValue())).sorted().map(class_2561::method_43470).forEach(panelText::add);
        } else {
            panelText.add((class_2561)class_2561.method_43470((String)"No sounds playing"));
        }
    }
}

