/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.overlay.plugins;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.gui.overlay.IDiagnosticPlugin;
import org.orecruncher.dsurround.lib.Comparers;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;

public class ViewerPlugin
implements IDiagnosticPlugin {
    private static final Object2ObjectOpenHashMap<String, class_2583> TAG_STYLES = new Object2ObjectOpenHashMap();
    private final Configuration.Logging config;
    private final IBlockLibrary blockLibrary;
    private final ITagLibrary tagLibrary;
    private final IEntityEffectLibrary entityEffectLibrary;

    public ViewerPlugin(Configuration.Logging config, IBlockLibrary blockLibrary, ITagLibrary tagLibrary, IEntityEffectLibrary entityEffectLibrary) {
        this.config = config;
        this.blockLibrary = blockLibrary;
        this.tagLibrary = tagLibrary;
        this.entityEffectLibrary = entityEffectLibrary;
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::onCollect);
    }

    private void processBlockHitResult(class_1937 world, class_3965 result, Collection<class_2561> data) {
        if (result.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2680 state = world.method_8320(result.method_17777());
        data.add((class_2561)class_2561.method_43470((String)state.toString()));
        this.processTags(state.method_41520(), data);
        if (!state.method_26227().method_15769()) {
            data.add((class_2561)class_2561.method_43470((String)"Fluid Tags"));
            this.processTags(state.method_26227().method_40180(), data);
        }
        BlockInfo info = this.blockLibrary.getBlockInfo(state);
        String wallOfText = info.toString();
        Arrays.stream(wallOfText.split("\n")).map(l -> l.replaceAll("[\\[\\]]", "").strip()).filter(s -> !Strings.isNullOrEmpty((String)s)).map(class_2561::method_43470).forEach(data::add);
    }

    private void processEntityHitResult(class_1297 entity, Collection<class_2561> data) {
        data.add((class_2561)class_2561.method_43470((String)String.valueOf(class_7923.field_41177.method_10221((Object)entity.method_5864()))));
        Optional<class_6880.class_6883<class_1299>> holderResult = RegistryUtils.getRegistryEntry(class_7924.field_41266, entity.method_5864());
        if (holderResult.isEmpty()) {
            return;
        }
        this.processTags((class_6880)holderResult.get(), data);
        if (entity instanceof class_1309) {
            class_1309 le = (class_1309)entity;
            EntityEffectInfo info = this.entityEffectLibrary.getEntityEffectInfo(le);
            if (info.isDefault()) {
                data.add((class_2561)class_2561.method_43470((String)"Default Effects"));
            } else {
                info.getEffects().forEach(effect -> data.add((class_2561)class_2561.method_43470((String)effect.toString())));
            }
        } else {
            data.add((class_2561)class_2561.method_43470((String)"Not a LivingEntity"));
        }
    }

    private void processHeldItem(class_1799 stack, Collection<class_2561> data) {
        if (stack.method_7960()) {
            return;
        }
        class_6880 holder = stack.method_41409();
        holder.method_40230().ifPresent(key -> data.add((class_2561)class_2561.method_43470((String)key.method_29177().toString())));
        this.processTags(holder, data);
    }

    private <T> void processTags(class_6880<T> holder, Collection<class_2561> data) {
        Stream<class_2960> query = this.tagLibrary.streamTags(holder).map(class_6862::comp_327);
        if (this.config.filteredTagView) {
            query = query.filter(loc -> TAG_STYLES.containsKey((Object)loc.method_12836()));
        }
        query.sorted(Comparers.IDENTIFIER_NATURAL_COMPARABLE).map(l -> {
            class_2583 formatting = (class_2583)TAG_STYLES.get((Object)l.method_12836());
            return class_2561.method_43470((String)("#" + String.valueOf(l))).method_27696(formatting);
        }).forEach(data::add);
    }

    @Override
    public void onCollect(CollectDiagnosticsEvent event) {
        class_1309 le;
        class_1799 stack;
        class_1297 entity = GameUtils.getMC().method_1560();
        if (entity == null) {
            return;
        }
        if (entity instanceof class_1309 && !(stack = (le = (class_1309)entity).method_5998(class_1268.field_5808)).method_7960()) {
            Collection<class_2561> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.HeldItem);
            this.processHeldItem(stack, panelText);
        }
        class_3965 blockHit = (class_3965)entity.method_5745(20.0, 0.0f, false);
        class_3965 fluidHit = (class_3965)entity.method_5745(20.0, 0.0f, true);
        class_1297 entityHit = GameUtils.getMC().field_1692;
        Collection<class_2561> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.BlockView);
        this.processBlockHitResult(entity.method_37908(), blockHit, panelText);
        if (!blockHit.method_17777().equals((Object)fluidHit.method_17777())) {
            panelText = event.getSectionText(CollectDiagnosticsEvent.Section.FluidView);
            this.processBlockHitResult(entity.method_37908(), fluidHit, panelText);
        }
        if (entityHit != null) {
            panelText = event.getSectionText(CollectDiagnosticsEvent.Section.EntityView);
            this.processEntityHitResult(entityHit, panelText);
        }
    }

    static {
        TAG_STYLES.defaultReturnValue((Object)class_2583.field_24360.method_27703(ColorPalette.GRAY));
        TAG_STYLES.put((Object)"dsurround", (Object)class_2583.field_24360.method_27703(ColorPalette.GOLD));
        TAG_STYLES.put((Object)"minecraft", (Object)class_2583.field_24360.method_27703(ColorPalette.FRESH_AIR));
        TAG_STYLES.put((Object)"forge", (Object)class_2583.field_24360.method_27703(ColorPalette.AQUAMARINE));
        TAG_STYLES.put((Object)"fabric", (Object)class_2583.field_24360.method_27703(ColorPalette.CORNSILK));
        TAG_STYLES.put((Object)"c", (Object)class_2583.field_24360.method_27703(ColorPalette.CORNSILK));
    }
}

