/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlListEntry;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public class IndividualSoundControlList
extends class_350<IndividualSoundControlListEntry> {
    private final class_437 parent;
    private final boolean enablePlay;
    private final ISoundLibrary soundLibrary = ContainerManager.resolve(ISoundLibrary.class);
    private int width;
    private List<IndividualSoundConfigEntry> source;
    private String lastSearchText = null;

    public IndividualSoundControlList(class_437 parent, class_310 mcIn, int widthIn, int heightIn, int topIn, int slotWidth, int slotHeightIn, boolean enablePlay, Supplier<String> filter, @Nullable IndividualSoundControlList oldList) {
        super(mcIn, widthIn, heightIn, topIn, slotHeightIn);
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.width = slotWidth;
        if (oldList != null) {
            this.source = oldList.source;
            this.calculateRowWidth();
        }
        this.setSearchFilter(filter);
    }

    public int method_25322() {
        return this.width;
    }

    public void setRowWidth(int width) {
        this.width = width - 40;
        this.method_25396().forEach(c -> c.setWidth(this.width));
    }

    protected int method_25329() {
        return (this.parent.field_22789 + this.method_25322()) / 2 + 20;
    }

    public void setSearchFilter(Supplier<String> filterBy) {
        String filter = filterBy.get();
        if (this.lastSearchText != null && this.lastSearchText.equals(filter)) {
            return;
        }
        this.lastSearchText = filter;
        this.method_25339();
        if (this.source == null) {
            this.source = new ArrayList<IndividualSoundConfigEntry>(this.getSortedSoundConfigurations());
            this.calculateRowWidth();
        }
        Predicate<IndividualSoundConfigEntry> process = StringUtils.isEmpty((CharSequence)filter) ? isc -> true : isc -> isc.soundEventIdProjected.contains(filter);
        IndividualSoundControlListEntry first = null;
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!process.test(cfg)) continue;
            IndividualSoundControlListEntry entry = new IndividualSoundControlListEntry(cfg, this.enablePlay);
            if (first == null) {
                first = entry;
            }
            this.method_25321((class_350.class_351)entry);
        }
        this.calculateRowWidth();
        if (first != null) {
            this.method_25328((class_350.class_351)first);
        }
    }

    @Nullable
    public IndividualSoundControlListEntry getEntryAt(int mouseX, int mouseY) {
        return (IndividualSoundControlListEntry)this.method_25308(mouseX, mouseY);
    }

    public void tick() {
        this.method_25396().forEach(IndividualSoundControlListEntry::tick);
    }

    protected Collection<IndividualSoundConfigEntry> getConfigs() {
        ArrayList<IndividualSoundConfigEntry> configs = new ArrayList<IndividualSoundConfigEntry>();
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!cfg.isNotDefault()) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public void saveChanges() {
        this.soundLibrary.saveIndividualSoundConfigs(this.getConfigs());
    }

    protected void method_47399(@NotNull class_6382 builder) {
    }

    protected Collection<IndividualSoundConfigEntry> getSortedSoundConfigurations() {
        HashMap<class_2960, IndividualSoundConfigEntry> map = new HashMap<class_2960, IndividualSoundConfigEntry>();
        for (class_3414 event : this.soundLibrary.getRegisteredSoundEvents()) {
            IndividualSoundConfigEntry entry = IndividualSoundConfigEntry.createDefault(event);
            map.put(entry.soundEventId, entry);
        }
        for (IndividualSoundConfigEntry entry : this.soundLibrary.getIndividualSoundConfigs()) {
            map.put(entry.soundEventId, entry);
        }
        return map.values().stream().sorted(IndividualSoundConfigEntry::compareTo).collect(Collectors.toList());
    }

    protected void calculateRowWidth() {
        if (!this.method_25396().isEmpty()) {
            Optional<Integer> width = this.method_25396().stream().map(IndividualSoundControlListEntry::getWidth).max(Integer::compareTo);
            width.ifPresent(w -> {
                this.width = w;
            });
        }
    }
}

