/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.gui.sound.BlockButton;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.gui.sound.CullButton;
import org.orecruncher.dsurround.gui.sound.SoundPlayButton;
import org.orecruncher.dsurround.gui.sound.VolumeSliderControl;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.gui.GuiHelpers;
import org.orecruncher.dsurround.lib.gui.TextWidget;
import org.orecruncher.dsurround.lib.platform.ModInformation;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.SoundMetadata;

public class IndividualSoundControlListEntry
extends class_4265.class_4266<IndividualSoundControlListEntry>
implements AutoCloseable {
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final IAudioPlayer AUDIO_PLAYER = ContainerManager.resolve(IAudioPlayer.class);
    private static final int TOOLTIP_WIDTH = 300;
    private static final class_2583 STYLE_MOD_NAME = class_2583.field_24360.method_27703(ColorPalette.GOLD);
    private static final class_2583 STYLE_ID = class_2583.field_24360.method_27703(ColorPalette.SLATEGRAY);
    private static final class_2583 STYLE_CATEGORY = class_2583.field_24360.method_27703(ColorPalette.FRESH_AIR);
    private static final class_2583 STYLE_SUBTITLE = class_2583.field_24360.method_27703(ColorPalette.APRICOT).method_10978(Boolean.valueOf(true));
    private static final class_2583 STYLE_CREDIT_NAME = class_2583.field_24360.method_27703(ColorPalette.GREEN);
    private static final class_2583 STYLE_CREDIT_AUTHOR = class_2583.field_24360.method_27703(ColorPalette.WHITE);
    private static final class_2583 STYLE_CREDIT_LICENSE = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_27703(ColorPalette.MC_DARKAQUA);
    private static final class_2583 STYLE_HELP = class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_27703(ColorPalette.KEY_LIME);
    private static final class_5481 VANILLA_CREDIT = class_2561.method_43471((String)"dsurround.text.soundconfig.vanilla").method_30937();
    private static final Collection<class_2561> VOLUME_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.volume.help", 300, STYLE_HELP);
    private static final Collection<class_2561> PLAY_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.play.help", 300, STYLE_HELP);
    private static final Collection<class_2561> CULL_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.cull.help", 300, STYLE_HELP);
    private static final Collection<class_2561> BLOCK_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.block.help", 300, STYLE_HELP);
    private static final int CONTROL_SPACING = 3;
    private final IndividualSoundConfigEntry config;
    private final TextWidget label;
    private final VolumeSliderControl volume;
    private final BlockButton blockButton;
    private final CullButton cullButton;
    @Nullable
    private final SoundPlayButton playButton;
    private final List<class_339> children = new ArrayList<class_339>();
    private final List<class_5481> cachedToolTip = new ArrayList<class_5481>();
    private ConfigSoundInstance soundPlay;

    public IndividualSoundControlListEntry(IndividualSoundConfigEntry data, boolean enablePlay) {
        this.config = data;
        Objects.requireNonNull(GameUtils.getTextRenderer());
        this.label = new TextWidget(0, 0, 200, 9, (class_2561)class_2561.method_43470((String)data.soundEventId.toString()), GameUtils.getTextRenderer());
        this.children.add((class_339)this.label);
        this.volume = new VolumeSliderControl(this, 0, 0);
        this.children.add((class_339)this.volume);
        this.blockButton = new BlockButton(this.config.block, this::toggleBlock);
        this.children.add((class_339)this.blockButton);
        this.cullButton = new CullButton(this.config.cull, this::toggleCull);
        this.children.add((class_339)this.cullButton);
        if (enablePlay) {
            this.playButton = new SoundPlayButton(this::play);
            this.children.add((class_339)this.playButton);
        } else {
            this.playButton = null;
        }
    }

    public int getWidth() {
        int width = this.label.method_25368();
        width += this.cullButton.method_25368() + this.blockButton.method_25368() + this.volume.method_25368() + 12;
        if (this.playButton != null) {
            width += this.playButton.method_25368() + 3;
        }
        return width;
    }

    public void setWidth(int width) {
        int fixedWidth = this.cullButton.method_25368() + this.blockButton.method_25368() + this.volume.method_25368() + 12;
        if (this.playButton != null) {
            fixedWidth += this.playButton.method_25368() + 3;
        }
        if ((width -= fixedWidth) < 100) {
            width = 100;
        }
        this.label.method_25358(width);
    }

    public void method_16014(double mouseX, double mouseY) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            child.method_16014(mouseX, mouseY);
        }
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        return ImmutableList.of();
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double hAmount, double vAmount) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25401(mouseX, mouseY, hAmount, vAmount);
        }
        return false;
    }

    private class_339 findChild(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            for (class_339 e : this.children) {
                if (!e.method_25405(mouseX, mouseY)) continue;
                return e;
            }
        }
        return null;
    }

    public void method_25343(@NotNull class_332 context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick_) {
        class_327 font = GameUtils.getTextRenderer();
        Objects.requireNonNull(font);
        int labelY = rowTop + (rowHeight - 9) / 2;
        this.label.method_46421(rowLeft);
        this.label.method_46419(labelY);
        int rightMargin = rowLeft + rowWidth;
        this.volume.method_46421(rightMargin - this.volume.method_25368());
        this.volume.method_46419(rowTop);
        this.volume.method_53533(rowHeight);
        rightMargin -= this.volume.method_25368() + 3;
        if (this.playButton != null) {
            this.playButton.method_46421(rightMargin - this.playButton.method_25368());
            this.playButton.method_46419(rowTop);
            this.playButton.method_53533(rowHeight);
            rightMargin -= this.playButton.method_25368() + 3;
        }
        this.blockButton.method_46421(rightMargin - this.blockButton.method_25368());
        this.blockButton.method_46419(rowTop);
        this.blockButton.method_53533(rowHeight);
        this.cullButton.method_46421((rightMargin -= this.blockButton.method_25368() + 3) - this.cullButton.method_25368());
        this.cullButton.method_53533(rowHeight);
        this.cullButton.method_46419(rowTop);
        for (class_339 w : this.children) {
            w.method_25394(context, mouseX, mouseY, partialTick_);
        }
    }

    protected void toggleBlock(class_4185 button) {
        if (button instanceof BlockButton) {
            BlockButton bb = (BlockButton)button;
            this.config.block = bb.toggle();
        }
    }

    protected void toggleCull(class_4185 button) {
        if (button instanceof CullButton) {
            CullButton cb = (CullButton)button;
            this.config.cull = cb.toggle();
        }
    }

    protected void play(class_4185 button) {
        if (button instanceof SoundPlayButton) {
            SoundPlayButton sp = (SoundPlayButton)button;
            if (this.soundPlay == null) {
                this.soundPlay = this.playSound(this.config);
                sp.play();
            } else {
                AUDIO_PLAYER.stop((class_1113)this.soundPlay);
                this.soundPlay = null;
                sp.stop();
            }
        }
    }

    protected ConfigSoundInstance playSound(IndividualSoundConfigEntry entry) {
        SoundMetadata metadata = SOUND_LIBRARY.getSoundMetadata(entry.soundEventId);
        ConfigSoundInstance sound = ConfigSoundInstance.create(entry.soundEventId, metadata.getCategory(), () -> Float.valueOf((float)entry.volumeScale / 100.0f));
        AUDIO_PLAYER.play((class_1113)sound);
        return sound;
    }

    @Override
    public void close() {
        if (this.soundPlay != null) {
            AUDIO_PLAYER.stop((class_1113)this.soundPlay);
            this.soundPlay = null;
        }
    }

    public void tick() {
        if (this.soundPlay != null && this.playButton != null && !AUDIO_PLAYER.isPlaying((class_1113)this.soundPlay)) {
            this.soundPlay = null;
            this.playButton.stop();
        }
    }

    protected List<class_5481> getToolTip(int mouseX, int mouseY) {
        if (this.cachedToolTip.isEmpty()) {
            class_2960 id = this.config.soundEventId;
            this.resolveDisplayName(id.method_12836()).ifPresent(name -> {
                class_5481 modName = class_5481.method_30747((String)Objects.requireNonNull(class_124.method_539((String)name)), (class_2583)STYLE_MOD_NAME);
                this.cachedToolTip.add(modName);
            });
            class_5481 soundLocationId = class_5481.method_30747((String)id.toString(), (class_2583)STYLE_ID);
            this.cachedToolTip.add(soundLocationId);
            SoundMetadata metadata = SOUND_LIBRARY.getSoundMetadata(id);
            if (metadata != null) {
                if (!metadata.getTitle().equals((Object)class_2561.method_43473())) {
                    this.cachedToolTip.add(metadata.getTitle().method_30937());
                }
                this.cachedToolTip.add(class_2561.method_43470((String)metadata.getCategory().toString()).method_27696(STYLE_CATEGORY).method_30937());
                if (!metadata.getSubTitle().equals((Object)class_2561.method_43473())) {
                    this.cachedToolTip.add(metadata.getSubTitle().method_27661().method_27696(STYLE_SUBTITLE).method_30937());
                }
                if (!metadata.getCredits().isEmpty()) {
                    for (SoundMetadata.Credit credit : metadata.getCredits()) {
                        this.cachedToolTip.add(class_2561.method_43473().method_30937());
                        this.cachedToolTip.add(credit.name().method_27661().method_27696(STYLE_CREDIT_NAME).method_30937());
                        this.cachedToolTip.add(credit.author().method_27661().method_27696(STYLE_CREDIT_AUTHOR).method_30937());
                        if (credit.webSite().isPresent()) {
                            this.cachedToolTip.add(credit.webSite().get().method_27661().method_27696(STYLE_CREDIT_AUTHOR).method_30937());
                        }
                        this.cachedToolTip.add(credit.license().method_27661().method_27696(STYLE_CREDIT_LICENSE).method_30937());
                    }
                }
            }
            if (id.method_12836().equals("minecraft")) {
                this.cachedToolTip.add(VANILLA_CREDIT);
            }
        }
        ArrayList<class_5481> generatedTip = new ArrayList<class_5481>(this.cachedToolTip);
        Collection<class_2561> toAppend = null;
        if (this.volume.method_25405(mouseX, mouseY)) {
            toAppend = VOLUME_HELP;
        } else if (this.blockButton.method_25405(mouseX, mouseY)) {
            toAppend = BLOCK_HELP;
        } else if (this.cullButton.method_25405(mouseX, mouseY)) {
            toAppend = CULL_HELP;
        } else if (this.playButton != null && this.playButton.method_25405(mouseX, mouseY)) {
            toAppend = PLAY_HELP;
        }
        if (toAppend != null) {
            generatedTip.add(class_5481.field_26385);
            toAppend.forEach(e -> generatedTip.add(e.method_30937()));
        }
        return generatedTip;
    }

    private Optional<String> resolveDisplayName(String namespace) {
        Optional<String> displayName = ModInformation.getModDisplayName(namespace);
        if (displayName.isPresent()) {
            return displayName;
        }
        return GameUtils.getResourceManager().method_29213().filter(pack -> pack.method_14406(class_3264.field_14188).contains(namespace)).map(class_3262::method_14409).findAny();
    }

    public IndividualSoundConfigEntry getData() {
        return this.config;
    }
}

