/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.block.BlockStateMatcher;
import org.orecruncher.dsurround.lib.block.MatchOnBlockTag;

public interface CodecExtensions<A>
extends Codec<A> {
    public static Codec<IMatcher<class_2680>> checkBlockStateSpecification(boolean allowTags) {
        Function<IMatcher, DataResult> func = value -> {
            if (!allowTags && value instanceof MatchOnBlockTag) {
                return DataResult.error(() -> String.format("Current context does not allow block matching based on tags (%s)", value));
            }
            return DataResult.success((Object)value);
        };
        return BlockStateMatcher.CODEC.flatXmap(func, func);
    }

    public static <A> Optional<A> deserialize(String content, Codec<A> codec) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)content);
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            DataResult result = codec.parse(dynamic);
            return result.resultOrPartial(x$0 -> Library.LOGGER.warn((String)x$0, new Object[0]));
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to parse input", new Object[0]);
            return Optional.empty();
        }
    }

    public static <A> Optional<String> serialize(Codec<A> codec, A entity) {
        try {
            return codec.encode(entity, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).result().map(je -> new GsonBuilder().setPrettyPrinting().create().toJson(je));
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to serialize entity", new Object[0]);
            return Optional.empty();
        }
    }
}

