/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import net.minecraft.class_1937;
import org.orecruncher.dsurround.lib.Localization;

public enum DayCycle {
    NO_SKY("NoSky"),
    SUNRISE("Sunrise"),
    SUNSET("Sunset"),
    DAYTIME("Daytime"),
    NIGHTTIME("Nighttime");

    private static final float DAYTIME_THRESHOLD = 274.0f;
    private static final float SUNRISE_THRESHOLD = 259.0f;
    private static final float NIGHTTIME_THRESHOLD = 94.0f;
    private static final float SUNSET_THRESHOLD = 79.0f;
    private final String localizeString;

    private DayCycle(String localName) {
        this.localizeString = "dsurround.format." + localName;
    }

    public static boolean isDaytime(class_1937 world) {
        return DayCycle.getCycle(world) == DAYTIME;
    }

    public static boolean isNighttime(class_1937 world) {
        return DayCycle.getCycle(world) == NIGHTTIME;
    }

    public static boolean isSunrise(class_1937 world) {
        return DayCycle.getCycle(world) == SUNRISE;
    }

    public static boolean isSunset(class_1937 world) {
        return DayCycle.getCycle(world) == SUNSET;
    }

    public static DayCycle getCycle(class_1937 world) {
        if (world.method_8597().comp_643() || !world.method_8597().comp_642()) {
            return NO_SKY;
        }
        float angleDegrees = world.method_30274(0.0f) * 360.0f;
        if (angleDegrees > 274.0f) {
            return DAYTIME;
        }
        if (angleDegrees > 259.0f) {
            return SUNRISE;
        }
        if (angleDegrees > 94.0f) {
            return NIGHTTIME;
        }
        if (angleDegrees > 79.0f) {
            return SUNSET;
        }
        return DAYTIME;
    }

    public static float getMoonSize(class_1937 world) {
        return world.method_30272();
    }

    public String getFormattedName() {
        return Localization.load(this.localizeString);
    }
}

