/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import com.google.common.base.Preconditions;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;

public final class Guard {
    private static final IModLog LOGGER = ContainerManager.resolve(IModLog.class);

    public static void execute(Runnable process) {
        Guard.executeImpl(process, LOGGER, false);
    }

    public static void executeWithThrow(Runnable process) {
        Guard.executeImpl(process, LOGGER, true);
    }

    public static void execute(Runnable process, IModLog logger) {
        Guard.executeImpl(process, logger, false);
    }

    public static void executeWithThrow(Runnable process, IModLog logger) {
        Guard.executeImpl(process, logger, true);
    }

    private static void executeImpl(Runnable process, IModLog logger, boolean rethrow) {
        block2: {
            Preconditions.checkNotNull((Object)process);
            Preconditions.checkNotNull((Object)logger);
            try {
                process.run();
            }
            catch (Throwable t) {
                logger.error(t, "Error processing request", new Object[0]);
                if (!rethrow) break block2;
                throw t;
            }
        }
    }
}

