/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import java.text.DecimalFormat;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.orecruncher.dsurround.lib.DayCycle;

public class MinecraftClock {
    private static final String AM = "dsurround.format.AM";
    private static final String PM = "dsurround.format.PM";
    private static final String TIME_FORMAT = "dsurround.format.TimeOfDay";
    private static final DecimalFormat minuteFormat = new DecimalFormat("00");
    protected int day;
    protected int hour;
    protected int minute;
    protected boolean isAM;
    protected DayCycle cycle = DayCycle.DAYTIME;

    public MinecraftClock() {
    }

    public MinecraftClock(class_1937 world) {
        this.update(world);
    }

    public void update(class_1937 world) {
        long time = world.method_8532();
        this.day = (int)(time / 24000L);
        ++this.day;
        this.hour = (int)((time -= (long)this.day * 24000L) / 1000L);
        this.minute = (int)((double)(time -= (long)this.hour * 1000L) / 16.666);
        this.hour += 6;
        if (this.hour >= 24) {
            this.hour -= 24;
            ++this.day;
        }
        this.isAM = this.hour < 12;
        this.cycle = DayCycle.getCycle(world);
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean isAM() {
        return this.isAM;
    }

    public DayCycle getCycle() {
        return this.cycle;
    }

    public String getTimeOfDay() {
        return this.cycle.getFormattedName();
    }

    public class_2561 getFormattedTime() {
        int h = this.hour;
        if (h > 12) {
            h -= 12;
        }
        if (h == 0) {
            h = 12;
        }
        return class_2561.method_43469((String)TIME_FORMAT, (Object[])new Object[]{this.day, h, minuteFormat.format(this.minute), class_2561.method_43471((String)(this.isAM ? AM : PM)), this.getTimeOfDay()});
    }

    public String toString() {
        return "[" + this.getFormattedTime().method_30937().toString() + "]";
    }
}

