/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.block.MatchOnBlockState;
import org.orecruncher.dsurround.lib.logging.IModLog;

public class BlockStateProperties {
    private static final IModLog LOGGER = Library.LOGGER;
    public static final BlockStateProperties NONE = new BlockStateProperties();
    private final Map<class_2769<?>, Comparable<?>> props;

    private BlockStateProperties() {
        this.props = ImmutableMap.of();
    }

    public BlockStateProperties(class_2680 state) {
        this(state.method_11656());
    }

    public BlockStateProperties(Map<class_2769<?>, Comparable<?>> props) {
        this.props = props;
    }

    public boolean matches(class_2680 state) {
        try {
            for (Map.Entry<class_2769<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable comp = state.method_11654(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable ignored) {
            LOGGER.warn("Property list %s does not correspond the properties in %s", this.toString(), new MatchOnBlockState(state).toString());
            return false;
        }
    }

    public boolean matches(BlockStateProperties props) {
        return this.matches(props.props);
    }

    public boolean matches(Map<class_2769<?>, Comparable<?>> m) {
        try {
            if (this.props == m) {
                return true;
            }
            if (this.props.size() > m.size()) {
                return false;
            }
            for (Map.Entry<class_2769<?>, Comparable<?>> kvp : this.props.entrySet()) {
                Comparable<?> comp = m.get(kvp.getKey());
                if (comp.equals(kvp.getValue())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int hashCode() {
        int code = 0;
        for (Map.Entry<class_2769<?>, Comparable<?>> kvp : this.props.entrySet()) {
            code = code * 31 + kvp.getKey().hashCode();
            code = code * 31 + kvp.getValue().hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockStateProperties)) {
            return false;
        }
        BlockStateProperties e = (BlockStateProperties)obj;
        return this.props.size() == e.props.size() && this.matches(e.props);
    }

    public String getFormattedProperties() {
        if (this.props.isEmpty()) {
            return "";
        }
        String txt = this.props.entrySet().stream().map(kvp -> ((class_2769)kvp.getKey()).method_11899() + "=" + ((Comparable)kvp.getValue()).toString()).collect(Collectors.joining(","));
        return "[" + txt + "]";
    }

    public String toString() {
        return "BlockStateProperties{" + this.getFormattedProperties() + "}";
    }
}

