/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigOptions;
import org.orecruncher.dsurround.lib.config.ConfigurationData;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public abstract class AbstractConfigScreenFactory
implements Function<class_437, class_437> {
    private static final class_2583 STYLE_RESTART = class_2583.field_24360.method_27703(ColorPalette.RED);
    private static final class_2561 CLIENT_RESTART_REQUIRED = class_2561.method_43471((String)"dsurround.config.tooltip.clientRestartRequired").method_27696(STYLE_RESTART);
    private static final class_2561 WORLD_RESTART_REQUIRED = class_2561.method_43471((String)"dsurround.config.tooltip.worldRestartRequired").method_27696(STYLE_RESTART);
    private static final class_2561 ASSET_RELOAD_REQUIRED = class_2561.method_43471((String)"dsurround.config.tooltip.assetReloadRequired").method_27696(STYLE_RESTART);
    private static final class_2561 EMPTY_LINE = class_2561.method_43470((String)" ");
    protected final ConfigOptions options;
    protected final ConfigurationData configData;

    public AbstractConfigScreenFactory(ConfigOptions options, ConfigurationData config) {
        this.options = options;
        this.configData = config;
    }

    protected Collection<class_2561> generateToolTipCollection(ConfigElement.PropertyValue<?> pv) {
        ConfigElement.IRangeTooltip rt;
        Collection<class_2561> toolTipEntries = this.options.transformTooltip(pv.getTooltip(this.options.getTooltipStyle()));
        toolTipEntries.add(EMPTY_LINE);
        toolTipEntries.add(pv.getDefaultValueTooltip());
        if (pv instanceof ConfigElement.IRangeTooltip && (rt = (ConfigElement.IRangeTooltip)((Object)pv)).hasRange()) {
            toolTipEntries.add(rt.getRangeTooltip());
        }
        if (pv.isClientRestartRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(CLIENT_RESTART_REQUIRED);
        } else if (pv.isWorldRestartRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(WORLD_RESTART_REQUIRED);
        } else if (pv.isAssetReloadRequired()) {
            toolTipEntries.add(EMPTY_LINE);
            toolTipEntries.add(ASSET_RELOAD_REQUIRED);
        }
        return toolTipEntries;
    }

    @Override
    public abstract class_437 apply(class_437 var1);
}

