/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import org.orecruncher.dsurround.lib.Localization;
import org.orecruncher.dsurround.lib.gui.GuiHelpers;

public class ConfigOptions {
    private String translationRoot = "";
    private class_2583 titleStyle = class_2583.field_24360;
    private class_2583 propertyGroupStyle = class_2583.field_24360;
    private class_2583 propertyStyle = class_2583.field_24360;
    private class_2583 tooltipStyle = class_2583.field_24360;
    private boolean wrapToolTip = false;
    private int toolTipWidth = 300;

    public ConfigOptions setTitleStyle(class_2583 style) {
        this.titleStyle = style;
        return this;
    }

    public ConfigOptions setPropertyGroupStyle(class_2583 style) {
        this.propertyGroupStyle = style;
        return this;
    }

    public ConfigOptions setPropertyStyle(class_2583 style) {
        this.propertyStyle = style;
        return this;
    }

    public ConfigOptions setTooltipStyle(class_2583 style) {
        this.tooltipStyle = style;
        return this;
    }

    public ConfigOptions setTooltipWidth(int width) {
        this.toolTipWidth = width;
        return this;
    }

    public ConfigOptions wrapToolTip(boolean flag) {
        this.wrapToolTip = flag;
        return this;
    }

    public class_2583 getTooltipStyle() {
        return this.tooltipStyle;
    }

    public ConfigOptions setTranslationRoot(String root) {
        this.translationRoot = root;
        return this;
    }

    public class_2561 transformTitle() {
        String txt = Localization.load(this.translationRoot + ".title");
        return class_2561.method_43470((String)txt).method_27696(this.titleStyle);
    }

    public class_2561 transformPropertyGroup(String langKey) {
        String txt = Localization.load(langKey);
        return class_2561.method_43470((String)txt).method_27696(this.propertyGroupStyle);
    }

    public class_2561 transformProperty(String langKey) {
        String txt = Localization.load(langKey);
        return class_2561.method_43470((String)txt).method_27696(this.propertyStyle);
    }

    public Collection<class_2561> transformTooltip(class_2561 tooltip) {
        if (this.wrapToolTip) {
            return GuiHelpers.getTrimmedTextCollection(tooltip, this.toolTipWidth, this.tooltipStyle);
        }
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        result.add(tooltip);
        return result;
    }
}

