/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import joptsimple.internal.Strings;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigurationData;
import org.orecruncher.dsurround.lib.config.ElementAccessor;

public class ConfigProcessor {
    public static <T extends ConfigurationData> Optional<T> createPrototype(Class<T> clazz) {
        try {
            Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return Optional.of((ConfigurationData)ctor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            Library.LOGGER.error(ex, "Unable to create prototype for %s", clazz.getName());
            return Optional.empty();
        }
    }

    public static <T extends ConfigurationData> Optional<Collection<ConfigElement<?>>> generateAccessors(Class<T> clazz) {
        try {
            ConfigurationData.TranslationRoot translationRootAnnotation = clazz.getAnnotation(ConfigurationData.TranslationRoot.class);
            String translationRoot = translationRootAnnotation != null ? translationRootAnnotation.value() : "dsurround";
            Optional<ConfigurationData> prototype = ConfigProcessor.createPrototype(clazz);
            return prototype.map(p -> new GenerationContext(clazz, translationRoot).generateLevel(p));
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to generate accessors for %s", clazz.getName());
            return Optional.empty();
        }
    }

    private record GenerationContext<T>(Class<?> clazz, String translationRoot) {
        public Collection<ConfigElement<?>> generateLevel(Object prototype) {
            Field[] fields;
            ObjectArray elements = new ObjectArray();
            for (Field f : fields = this.clazz.getFields()) {
                ConfigElement<?> element;
                ConfigurationData.Property property = f.getAnnotation(ConfigurationData.Property.class);
                if (property == null) continue;
                Class<?> fieldType = f.getType();
                if (!fieldType.isPrimitive()) {
                    if (fieldType.isEnum()) {
                        elements.add(this.processEnumInstance(property, prototype, f));
                        continue;
                    }
                    elements.add(this.processClassInstance(property, prototype, f));
                    continue;
                }
                if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                    element = this.processIntegerInstance(property, prototype, f);
                } else if (fieldType == Double.class || fieldType == Float.class || fieldType == Double.TYPE || fieldType == Float.TYPE) {
                    element = this.processDoubleInstance(property, prototype, f);
                } else if (fieldType == String.class) {
                    element = this.processStringInstance(property, prototype, f);
                } else {
                    if (fieldType != Boolean.class && fieldType != Boolean.TYPE) continue;
                    element = this.processBooleanInstance(property, prototype, f);
                }
                elements.add(element);
            }
            return elements;
        }

        GenerationContext<T> createChild(Class<?> clazz, String langKey) {
            return new GenerationContext<T>(clazz, langKey);
        }

        private ConfigElement<?> processEnumInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigurationData.EnumType enumType = f.getAnnotation(ConfigurationData.EnumType.class);
            if (enumType == null) {
                throw new RuntimeException("Enum field must have an EnumType annotation");
            }
            return new ConfigElement.EnumValue(enumType.value(), instance, this.calculateLangKey(property, f), f);
        }

        private ConfigElement<?> processClassInstance(ConfigurationData.Property property, Object instance, Field f) {
            ElementAccessor wrapper = new ElementAccessor(f);
            String key = this.calculateLangKey(property, f);
            GenerationContext<T> ctx = this.createChild(f.getType(), key);
            Collection<ConfigElement<?>> subElements = ctx.generateLevel(wrapper.get(instance));
            return new ConfigElement.PropertyGroup(key, subElements, f);
        }

        private ConfigElement<?> processStringInstance(ConfigurationData.Property property, Object instance, Field f) {
            return new ConfigElement.StringValue(instance, this.calculateLangKey(property, f), f);
        }

        private ConfigElement<?> processBooleanInstance(ConfigurationData.Property property, Object instance, Field f) {
            return new ConfigElement.BooleanValue(instance, this.calculateLangKey(property, f), f);
        }

        private ConfigElement<?> processIntegerInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigElement.IntegerValue element = new ConfigElement.IntegerValue(instance, this.calculateLangKey(property, f), f);
            ConfigurationData.IntegerRange range = f.getAnnotation(ConfigurationData.IntegerRange.class);
            if (range != null) {
                element.setRange(range.min(), range.max());
            }
            return element;
        }

        private ConfigElement<?> processDoubleInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigElement.DoubleValue element = new ConfigElement.DoubleValue(instance, this.calculateLangKey(property, f), f);
            ConfigurationData.DoubleRange range = f.getAnnotation(ConfigurationData.DoubleRange.class);
            if (range != null) {
                element.setRange(range.min(), range.max());
            }
            return element;
        }

        private String calculateLangKey(ConfigurationData.Property property, Field f) {
            String segment = f.getName();
            if (!Strings.isNullOrEmpty((String)property.value())) {
                segment = property.value();
            }
            return this.translationRoot + "." + segment;
        }
    }
}

