/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigProcessor;
import org.orecruncher.dsurround.lib.events.EventingFactory;
import org.orecruncher.dsurround.lib.events.IEvent;
import org.orecruncher.dsurround.lib.platform.ModInformation;

public abstract class ConfigurationData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Class<? extends ConfigurationData>, Collection<ConfigElement<?>>> SPECIFICATIONS = new IdentityHashMap();
    private static final Map<Class<? extends ConfigurationData>, ConfigurationData> CONFIGS = new IdentityHashMap<Class<? extends ConfigurationData>, ConfigurationData>();
    final transient Path configFilePath = ConfigurationData.computePath(this.getClass());
    public static final IEvent<IConfigChangedEvent> CONFIG_CHANGED = EventingFactory.createEvent(callbacks -> config -> {
        for (IConfigChangedEvent callback : callbacks) {
            callback.onChange(config);
        }
    });

    protected ConfigurationData() {
    }

    @NotNull
    public static <T extends ConfigurationData> T getConfig(Class<T> clazz) {
        return (T)Objects.requireNonNull(CONFIGS.computeIfAbsent(clazz, ConfigurationData::computeConfiguration));
    }

    @Nullable
    public static <T extends ConfigurationData> Collection<ConfigElement<?>> getSpecification(Class<T> clazz) {
        Optional<Collection<ConfigElement<?>>> specResult;
        Collection<ConfigElement<?>> spec = SPECIFICATIONS.get(clazz);
        if (spec == null && (specResult = ConfigProcessor.generateAccessors(clazz)).isPresent()) {
            spec = specResult.get();
            SPECIFICATIONS.put(clazz, spec);
        }
        return spec;
    }

    private static Path computePath(Class<?> clazz) {
        ConfigPlacement configFolderAnnotation = clazz.getAnnotation(ConfigPlacement.class);
        if (configFolderAnnotation == null) {
            throw new RuntimeException("Configuration class must have a ConfigFolder annotation");
        }
        return ModInformation.getConfigPath(configFolderAnnotation.folderName()).resolve(configFolderAnnotation.fileName() + ".json");
    }

    private static <T extends ConfigurationData> T computeConfiguration(Class<T> clazz) {
        try {
            ConfigurationData config;
            block11: {
                Path configFolderPath = ConfigurationData.computePath(clazz);
                Collection<ConfigElement<?>> ignored = ConfigurationData.getSpecification(clazz);
                config = (ConfigurationData)ConfigProcessor.createPrototype(clazz).orElseThrow();
                try {
                    if (!Files.exists(configFolderPath, new LinkOption[0])) break block11;
                    try (BufferedReader reader = Files.newBufferedReader(configFolderPath);){
                        config = (ConfigurationData)GSON.fromJson((Reader)reader, clazz);
                    }
                }
                catch (Throwable t) {
                    Library.LOGGER.error(t, "Unable to handle configuration", new Object[0]);
                }
            }
            if (config == null) {
                Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                config = (ConfigurationData)ctor.newInstance(new Object[0]);
            }
            config.postLoad();
            config.save();
            return (T)config;
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to handle configuration", new Object[0]);
            return null;
        }
    }

    public Collection<ConfigElement<?>> getSpecification() {
        return SPECIFICATIONS.get(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Files.createDirectories(this.configFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configFilePath, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to save configuration %s", t.getMessage());
        }
        finally {
            CONFIG_CHANGED.raise().onChange(this);
        }
    }

    public void postLoad() {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfigPlacement {
        public String folderName();

        public String fileName();
    }

    @FunctionalInterface
    public static interface IConfigChangedEvent {
        public void onChange(ConfigurationData var1);
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EnumType {
        public Class<? extends Enum<?>> value();
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Hidden {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Slider {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WorldReloadRequired {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AssetReloadRequired {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RestartRequired {
        public boolean client() default true;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DoubleRange {
        public double min();

        public double max() default 1.7976931348623157E308;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntegerRange {
        public int min();

        public int max() default 0x7FFFFFFF;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String value() default "";
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TranslationRoot {
        public String value() default "dsurround";
    }
}

