/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.di.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.Singleton;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.di.DependencyConstructor;
import org.orecruncher.dsurround.lib.di.IServiceContainer;
import org.orecruncher.dsurround.lib.di.Injection;

public class DependencyContainer
implements IServiceContainer {
    private final Map<Class<?>, Supplier<?>> _resolvers;
    private final String _name;
    private final ContainerManager _manager;
    @Nullable
    private final DependencyContainer _parent;

    public DependencyContainer(String containerName, ContainerManager manager) {
        this(containerName, manager, null);
    }

    public DependencyContainer(String containerName, ContainerManager manager, @Nullable DependencyContainer parent) {
        this._name = containerName;
        this._manager = manager;
        this._parent = parent;
        this._resolvers = new IdentityHashMap();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Stream<String> dumpRegistrations() {
        return this._resolvers.entrySet().stream().map(kvp -> {
            StringBuilder builder = new StringBuilder();
            builder.append(((Class)kvp.getKey()).getName()).append(" [");
            if (kvp.getValue() instanceof Singleton) {
                builder.append("SINGLETON");
            } else {
                builder.append("PER INSTANCE");
            }
            return builder.append("]").toString();
        }).sorted();
    }

    @Override
    public IServiceContainer createChildContainer(String containerName) {
        DependencyContainer container = new DependencyContainer(containerName, this._manager, this);
        this._manager.registerContainer(container);
        return container;
    }

    @Override
    public <T> DependencyContainer registerSingleton(Class<T> clazz) {
        try {
            this.checkForKeySuitability(clazz);
            this.checkForResolverSuitability(clazz);
            return this.registerFactory(clazz, new Lazy<Object>(() -> this.createFactory(clazz).get()));
        }
        catch (Throwable ex) {
            Library.LOGGER.error(ex, "Unable to register singleton %s", clazz.getName());
            throw ex;
        }
    }

    @Override
    public <T> DependencyContainer registerSingleton(Class<T> clazz, Class<? extends T> desiredClass) {
        try {
            this.checkForKeySuitability(clazz);
            this.checkForResolverSuitability(desiredClass);
            return this.registerFactory(clazz, new Lazy<Object>(() -> this.createFactory(desiredClass).get()));
        }
        catch (Throwable ex) {
            Library.LOGGER.error(ex, "Unable to register singleton %s using class %s", clazz.getName(), desiredClass.getName());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> DependencyContainer registerFactory(Class<T> clazz, Supplier<? extends T> supplier) {
        try {
            this.checkForKeySuitability(clazz);
            Map<Class<?>, Supplier<?>> map = this._resolvers;
            synchronized (map) {
                this._resolvers.put(clazz, supplier);
            }
            return this;
        }
        catch (Throwable ex) {
            Library.LOGGER.error(ex, "Unable to register factor for class %s", clazz.getName());
            throw ex;
        }
    }

    @Override
    public <T> T resolve(Class<T> clazz) {
        try {
            Supplier<?> resolver = this.findResolver(clazz);
            if (resolver != null) {
                return (T)resolver.get();
            }
            Supplier<T> factory = this.createFactory(clazz);
            T result = factory.get();
            if (!clazz.isAnnotationPresent(Cacheable.class)) {
                this.registerFactory(clazz, factory);
            } else {
                this.registerFactory(clazz, new Singleton<T>(result));
            }
            return result;
        }
        catch (Throwable ex) {
            Library.LOGGER.error(ex, "Unable to resolve class %s", clazz.getName());
            throw ex;
        }
    }

    private static List<Field> getInjectedFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Injection.class)) continue;
                fields.add(field);
            }
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        return fields;
    }

    private static Object createInstance(Constructor<?> constructor) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return constructor.newInstance(new Object[0]);
    }

    private static Object createInstance(Constructor<?> constructor, Supplier<?>[] parameterResolvers) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Object[] parameters = new Object[parameterResolvers.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = parameterResolvers[i].get();
        }
        return constructor.newInstance(parameters);
    }

    private static Object applyInjectors(Object instance, List<Consumer<Object>> injections) {
        for (Consumer<Object> injector : injections) {
            injector.accept(instance);
        }
        return instance;
    }

    private void checkForKeySuitability(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new RuntimeException(String.format("'%s' is a primitive type and cannot be used for dependency injection", clazz.getName()));
        }
        if (clazz.equals(Object.class)) {
            throw new RuntimeException("Object is not a suitable key");
        }
        if (clazz.equals(Optional.class)) {
            throw new RuntimeException("Cannot use an optional as a key");
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new RuntimeException(String.format("Class '%s' is not public", clazz.getName()));
        }
    }

    private void checkForResolverSuitability(Class<?> clazz) {
        if (clazz.isInterface()) {
            throw new RuntimeException(String.format("The class %s is an interface and cannot be instantiated directly", clazz.getName()));
        }
        if (clazz.equals(Optional.class)) {
            throw new RuntimeException("Cannot use an optional as a resolved type");
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new RuntimeException(String.format("Class '%s' is not public", clazz.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Supplier<?> findResolver(Class<?> clazz) {
        Supplier<?> resolver;
        Map<Class<?>, Supplier<?>> map = this._resolvers;
        synchronized (map) {
            resolver = this._resolvers.get(clazz);
            if (resolver == null && this._parent != null) {
                resolver = this._parent.findResolver(clazz);
            }
        }
        return resolver;
    }

    private <T> Supplier<T> createFactory(Class<T> clazz) {
        this.checkForResolverSuitability(clazz);
        Constructor<?> constructor = this.findSuitableConstructor(clazz);
        Class<?>[] pTypes = constructor.getParameterTypes();
        Supplier[] parameterResolvers = new Supplier[pTypes.length];
        if (pTypes.length > 0) {
            for (int i = 0; i < pTypes.length; ++i) {
                Supplier<?> resolver = this.findResolver(pTypes[i]);
                if (resolver == null) {
                    throw new RuntimeException(String.format("Unable to resolve type %s", pTypes[i].getName()));
                }
                parameterResolvers[i] = resolver;
            }
        }
        ArrayList<Consumer<Object>> injections = new ArrayList<Consumer<Object>>();
        for (Field field : DependencyContainer.getInjectedFields(clazz)) {
            Class<?> type = field.getType();
            Supplier<?> resolver = this.findResolver(type);
            if (resolver == null) {
                throw new RuntimeException(String.format("Unable to resolve type %s", type.getName()));
            }
            field.setAccessible(true);
            injections.add(obj -> {
                try {
                    field.set(obj, resolver.get());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage());
                }
            });
        }
        if (pTypes.length == 0 && injections.isEmpty()) {
            return () -> {
                try {
                    return DependencyContainer.createInstance(constructor);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            };
        }
        if (injections.isEmpty()) {
            return () -> {
                try {
                    return DependencyContainer.createInstance(constructor, parameterResolvers);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            };
        }
        if (pTypes.length == 0) {
            return () -> {
                Object created = null;
                try {
                    created = DependencyContainer.createInstance(constructor);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                return DependencyContainer.applyInjectors(created, injections);
            };
        }
        return () -> {
            Object created = null;
            try {
                created = DependencyContainer.createInstance(constructor, parameterResolvers);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return DependencyContainer.applyInjectors(created, injections);
        };
    }

    private Constructor<?> findSuitableConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException(String.format("Class '%s' does not have any constructors declared", clazz.getName()));
        }
        if (constructors.length == 1) {
            return constructors[0];
        }
        if ((constructors = (Constructor[])Arrays.stream(constructors).filter(c -> c.isAnnotationPresent(DependencyConstructor.class)).toArray(Constructor[]::new)).length == 0) {
            throw new RuntimeException(String.format("Class '%s' has more than one constructor declared and none have the @DependencyConstructor annotation", clazz.getName()));
        }
        if (constructors.length > 1) {
            throw new RuntimeException(String.format("Class '%s' has more than one constructor with the @DependencyConstructor annotation.  Only annotate a single constructor.", clazz.getName()));
        }
        return constructors[0];
    }
}

