/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.events.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import org.orecruncher.dsurround.lib.events.EventPhases;
import org.orecruncher.dsurround.lib.events.IEvent;
import org.orecruncher.dsurround.lib.events.IPhasedEvent;
import org.orecruncher.dsurround.lib.events.internal.Event;
import org.orecruncher.dsurround.lib.events.internal.PhasedEvent;

public final class EventFactoryImpl {
    private EventFactoryImpl() {
    }

    public static <THandler> IPhasedEvent<THandler> createPhasedEvent(Function<Collection<THandler>, THandler> callbackProcessor, EventPhases phasedOrdering) {
        Preconditions.checkNotNull(callbackProcessor, (Object)"Callback processor must be provided");
        Preconditions.checkNotNull((Object)phasedOrdering, (Object)"Phased ordering must be provided");
        return new PhasedEvent<THandler>(phasedOrdering.getPhases(), callbackProcessor);
    }

    public static <THandler> IEvent<THandler> createEvent(Function<Collection<THandler>, THandler> callbackProcessor) {
        Preconditions.checkNotNull(callbackProcessor, (Object)"Callback handler must be provided");
        return new Event<THandler>(callbackProcessor);
    }
}

