/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.gui.ColorPalette;

public class WarmToast
implements class_368 {
    private static final Profile DEFAULT_PROFILE = new Profile(class_2960.method_60656((String)"toast/advancement"), 5000, ColorPalette.GOLD, ColorPalette.WHITE);
    private static final int MAX_LINE_SIZE = 200;
    private static final int MIN_LINE_SIZE = 100;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final Profile profile;
    private class_2561 title;
    private List<class_5481> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;

    public static WarmToast multiline(class_310 minecraft, class_2561 title, class_2561 body) {
        return WarmToast.multiline(minecraft, DEFAULT_PROFILE, title, body);
    }

    public static WarmToast multiline(class_310 minecraft, Profile profile, class_2561 title, class_2561 body) {
        class_327 font = minecraft.field_1772;
        List list = font.method_1728((class_5348)body, 200);
        int titleSize = Math.min(200, Math.max(100, font.method_27525((class_5348)title)));
        int lineSize = list.stream().mapToInt(arg_0 -> ((class_327)font).method_30880(arg_0)).max().orElse(100);
        int width = Math.max(titleSize, lineSize) + 30;
        return new WarmToast(profile, title, list, width);
    }

    private WarmToast(Profile profile, class_2561 title, List<class_5481> body, int width) {
        this.profile = profile;
        this.title = title;
        this.messageLines = body;
        this.width = width;
    }

    public int method_29049() {
        return this.width;
    }

    public int method_29050() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public void reset(class_2561 component, @Nullable class_2561 component2) {
        this.title = component;
        this.messageLines = WarmToast.nullToEmpty(component2);
        this.changed = true;
    }

    @NotNull
    public class_368.class_369 method_1986(@NotNull class_332 guiGraphics, @NotNull class_374 toastComponent, long lastChanged) {
        int i;
        if (this.changed) {
            this.lastChanged = lastChanged;
            this.changed = false;
        }
        if ((i = this.method_29049()) == 160 && this.messageLines.size() <= 1) {
            guiGraphics.method_52706(this.profile.sprite, 0, 0, i, this.method_29050());
        } else {
            int renderHeight = this.method_29050();
            int lineRenderCount = Math.min(4, renderHeight - 28);
            this.renderBackgroundRow(guiGraphics, i, 0, 0, 28);
            for (int n = 28; n < renderHeight - lineRenderCount; n += 10) {
                this.renderBackgroundRow(guiGraphics, i, 16, n, Math.min(16, renderHeight - n - lineRenderCount));
            }
            this.renderBackgroundRow(guiGraphics, i, 32 - lineRenderCount, renderHeight - lineRenderCount, lineRenderCount);
        }
        if (this.messageLines.isEmpty()) {
            guiGraphics.method_51439(toastComponent.method_1995().field_1772, this.title, 18, 12, this.profile.titleColor.method_27716(), false);
        } else {
            guiGraphics.method_51439(toastComponent.method_1995().field_1772, this.title, 18, 7, this.profile.titleColor.method_27716(), false);
            for (int j = 0; j < this.messageLines.size(); ++j) {
                guiGraphics.method_51430(toastComponent.method_1995().field_1772, this.messageLines.get(j), 18, 18 + j * 12, this.profile.bodyColor.method_27716(), false);
            }
        }
        double d = (double)this.profile.displayTime * toastComponent.method_48221();
        long o = lastChanged - this.lastChanged;
        return (double)o < d ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    private void renderBackgroundRow(class_332 guiGraphics, int i, int j, int k, int l) {
        int m = j == 0 ? 20 : 5;
        int n = Math.min(60, i - m);
        guiGraphics.method_52708(this.profile.sprite, 160, 32, 0, j, 0, k, m, l);
        for (int o = m; o < i - n; o += 64) {
            guiGraphics.method_52708(this.profile.sprite, 160, 32, 32, j, o, k, Math.min(64, i - o - n), l);
        }
        guiGraphics.method_52708(this.profile.sprite, 160, 32, 160 - n, j, i - n, k, n, l);
    }

    private static ImmutableList<class_5481> nullToEmpty(@Nullable class_2561 component) {
        return component == null ? ImmutableList.of() : ImmutableList.of((Object)component.method_30937());
    }

    public record Profile(class_2960 sprite, int displayTime, class_5251 titleColor, class_5251 bodyColor) {
    }
}

