/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.logging;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModLog
implements IModLog {
    private static final Pattern REGEX_SPLIT = Pattern.compile("\\n");
    private static boolean debugging;
    private static int traceMask;
    private final Logger logger;

    ModLog(Logger logger) {
        this.logger = logger;
    }

    public static IModLog create(String modId) {
        Logger logger = LoggerFactory.getLogger((String)Objects.requireNonNull(modId));
        return new ModLog(logger);
    }

    public static IModLog createChild(IModLog parent, String childName) {
        if (parent instanceof ModLog) {
            ModLog ml = (ModLog)parent;
            String child = ml.logger.getName() + "/" + childName;
            return ModLog.create(child);
        }
        throw new RuntimeException("parent is not an instance of ModLog");
    }

    private static void outputLines(Consumer<String> out, String format, Object ... params) {
        String output = format;
        if (params != null && params.length > 0) {
            output = String.format(format, params);
        }
        REGEX_SPLIT.splitAsStream(output).forEach(out);
    }

    public void setDebug(boolean flag) {
        debugging = flag;
    }

    public void setTraceMask(int mask) {
        traceMask = mask;
    }

    public boolean testTrace(int mask) {
        return (traceMask & mask) != 0;
    }

    @Override
    public boolean isDebugging() {
        return debugging;
    }

    @Override
    public boolean isTracing(int mask) {
        return this.isDebugging() && (traceMask & mask) != 0;
    }

    @Override
    public void info(String msg, Object ... params) {
        ModLog.outputLines(arg_0 -> ((Logger)this.logger).info(arg_0), msg, params);
    }

    @Override
    public void info(Supplier<String> message) {
        this.info(message.get(), new Object[0]);
    }

    @Override
    public void warn(String msg, Object ... params) {
        ModLog.outputLines(arg_0 -> ((Logger)this.logger).warn(arg_0), msg, params);
    }

    @Override
    public void warn(Supplier<String> message) {
        this.warn(message.get(), new Object[0]);
    }

    @Override
    public void debug(String msg, Object ... params) {
        if (this.isDebugging()) {
            ModLog.outputLines(arg_0 -> ((Logger)this.logger).info(arg_0), msg, params);
        }
    }

    @Override
    public void debug(Supplier<String> message) {
        if (this.isDebugging()) {
            this.debug(message.get(), new Object[0]);
        }
    }

    @Override
    public void debug(int mask, String msg, Object ... params) {
        if (this.isDebugging() && this.testTrace(mask)) {
            ModLog.outputLines(arg_0 -> ((Logger)this.logger).info(arg_0), msg, params);
        }
    }

    @Override
    public void debug(int mask, Supplier<String> message) {
        if (this.isDebugging()) {
            this.debug(mask, message.get(), new Object[0]);
        }
    }

    @Override
    public void error(Throwable e, String msg, Object ... params) {
        ModLog.outputLines(arg_0 -> ((Logger)this.logger).error(arg_0), msg, params);
        this.logger.error(e.toString());
    }

    @Override
    public void error(Throwable e, Supplier<String> message) {
        this.error(e, message.get(), new Object[0]);
    }
}

