/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.platform;

import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_155;
import org.orecruncher.dsurround.lib.Library;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.version.SemanticVersion;

public final class ModInformation
implements IMinecraftDirectories {
    private static final URI modUpdate = URI.create("https://raw.githubusercontent.com/OreCruncher/DynamicSurroundingsFabric/main/versions.json");
    private static final String modCurseForge = "https://www.curseforge.com/minecraft/mc-mods/dynamic-surroundings-fabric-edition";
    private static final String modModrinth = "https://modrinth.com/mod/dynamicsurroundingsfabric";
    private final String modId;
    private final String displayName;
    private final SemanticVersion version;
    private final Path modConfigDirectory;
    private final Path modDataDirectory;
    private final Path modDumpDirectory;

    public ModInformation(String modId, String displayName, SemanticVersion version) {
        this.modId = modId;
        this.displayName = displayName;
        this.version = version;
        this.modConfigDirectory = ModInformation.getConfigPath(modId);
        this.modDataDirectory = this.modConfigDirectory.resolve("configs");
        this.modDumpDirectory = this.modConfigDirectory.resolve("dumps");
        ModInformation.createPath(this.modDataDirectory);
        ModInformation.createPath(this.modDumpDirectory);
    }

    public String modId() {
        return this.modId;
    }

    public String displayName() {
        return this.displayName;
    }

    public SemanticVersion version() {
        return this.version;
    }

    @Override
    public Path getModConfigDirectory() {
        return this.modConfigDirectory;
    }

    @Override
    public Path getModDataDirectory() {
        return this.modDataDirectory;
    }

    @Override
    public Path getModDumpDirectory() {
        return this.modDumpDirectory;
    }

    public Optional<URL> getUpdateUrl() {
        try {
            return Optional.of(modUpdate.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return Optional.empty();
        }
    }

    public String curseForgeLink() {
        return modCurseForge;
    }

    public String modrinthLink() {
        return modModrinth;
    }

    public String getBranding() {
        return String.format("%s %s-%s", this.displayName, class_155.method_16673().method_48019(), this.version);
    }

    public static Optional<ModInformation> getModInformation(String modId) {
        return Platform.getOptionalMod((String)modId).map(info -> {
            try {
                String displayName = info.getName();
                SemanticVersion version = SemanticVersion.parse(info.getVersion());
                ModInformation result = new ModInformation(modId, displayName, version);
                return Optional.of(result);
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }).orElse(Optional.empty());
    }

    public static Optional<SemanticVersion> getMinecraftVersion() {
        return ModInformation.getModVersion("minecraft");
    }

    public static Optional<SemanticVersion> getModVersion(String namespace) {
        Mod container = Platform.getMod((String)namespace);
        if (container != null) {
            try {
                String version = container.getVersion();
                return Optional.of(SemanticVersion.parse(version));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getModDisplayName(String modId) {
        try {
            Mod container = Platform.getMod((String)modId);
            if (container != null) {
                return Optional.of(container.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Path getConfigPath(String modId) {
        Path configDir = Platform.getConfigFolder();
        Path configPath = configDir.resolve(Objects.requireNonNull(modId));
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectory(configPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Library.LOGGER.error(ex, "Unable to create directory path %s", configPath.toString());
                configPath = configDir;
            }
        }
        return configPath;
    }

    private static void createPath(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Throwable t) {
            Library.LOGGER.error(t, "Unable to create data path %s", path.toString());
        }
    }
}

