/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.AbstractResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;

public class ClientResourceFinder
extends AbstractResourceFinder {
    private final class_3300 resourceManager;

    protected ClientResourceFinder(IModLog logger, class_3300 resourceManager) {
        super(logger);
        this.resourceManager = resourceManager;
    }

    @Override
    public <T> Collection<DiscoveredResource<T>> find(Codec<T> codec, String assetPath) {
        HashMap<class_2960, Collection> results = new HashMap<class_2960, Collection>();
        this.logger.debug(4, "[%s] - Locating assets", assetPath);
        Map assets = this.resourceManager.method_41265(assetPath, location -> true);
        if (assets.isEmpty()) {
            this.logger.debug(4, "[%s] - No assets found", assetPath);
            return ImmutableList.of();
        }
        this.logger.debug(4, "[%s] - %d entries found", assetPath, assets.size());
        for (Map.Entry kvp : assets.entrySet()) {
            this.logger.debug(4, "[%s] - Processing %s", assetPath, kvp.getKey());
            Collection resultList = results.computeIfAbsent((class_2960)kvp.getKey(), i -> new ObjectArray());
            for (class_3298 resource : (List)kvp.getValue()) {
                try {
                    InputStream inputStream = resource.method_14482();
                    try {
                        byte[] assetBytes = inputStream.readAllBytes();
                        String assetString = new String(assetBytes, Charset.defaultCharset());
                        Optional<Object> entity = this.decode((class_2960)kvp.getKey(), assetString, codec);
                        entity.ifPresent(e -> resultList.add(new DiscoveredResource<Object>(((class_2960)kvp.getKey()).method_12836(), e)));
                        this.logger.debug(4, "[%s] - Completed decode of %s", assetPath, kvp.getKey());
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Throwable t) {
                    this.logger.error(t, "[%s] - Unable to read resource stream for path %s", assetPath, kvp.getKey());
                }
            }
        }
        return results.values().stream().flatMap(Collection::stream).toList();
    }
}

