/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7475;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.MinecraftServerType;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;

public class ClientTagLoader {
    private final IModLog logger;
    private final ISystemClock systemClock;
    private final Map<class_6862<?>, TagData<?>> tagCache = new Reference2ObjectOpenHashMap(256);
    private MinecraftServerType serverType;
    @NotNull
    private ResourceUtilities resourceUtilities;

    public ClientTagLoader(@NotNull ResourceUtilities resourceUtilities, IModLog logger, ISystemClock systemClock) {
        this.resourceUtilities = resourceUtilities;
        this.logger = ModLog.createChild(logger, "ClientTagLoader");
        this.systemClock = systemClock;
        this.serverType = MinecraftServerType.VANILLA;
    }

    public Collection<class_2960> getMembers(class_6862<?> tagKey) {
        return this.getTagData(tagKey, new HashSet()).members();
    }

    public <T> Collection<class_2960> getCompleteIds(class_6862<T> tagKey) {
        return this.getTagData(tagKey, new HashSet()).members();
    }

    public void clear() {
        this.logger.debug(4, "Clearing client tag loader", new Object[0]);
        this.tagCache.clear();
    }

    public void setResourceUtilities(ResourceUtilities resourceUtilities) {
        if (this.resourceUtilities != resourceUtilities) {
            this.resourceUtilities = resourceUtilities;
            this.clear();
        }
    }

    public void setServerType(MinecraftServerType serverType) {
        if (this.serverType != serverType) {
            this.clear();
            this.serverType = serverType;
        }
    }

    private <T> TagData<T> getTagData(class_6862<T> tagKey, Set<class_6862<?>> visited) {
        TagData<Object> data = this.tagCache.get(tagKey);
        if (data == null) {
            if (visited.contains(tagKey)) {
                this.logger.debug(4, "%s - Previously encountered; skipping", tagKey);
                return TagData.empty();
            }
            visited.add(tagKey);
            this.logger.debug(4, "%s - Loading tag files", tagKey);
            data = this.loadTagData(tagKey, visited);
            this.logger.debug(4, "%s - Caching results; total of %d members", tagKey, data.members().size());
            this.tagCache.put(tagKey, data);
        } else {
            this.logger.debug(4, "%s - Already in cache; total of %d members", tagKey, data.members().size());
        }
        return TagData.cast(data);
    }

    private <T> TagData<T> loadTagData(final class_6862<T> tagKey, final Set<class_6862<?>> visited) {
        HashSet completeIds = new HashSet();
        Optional<Iterable<class_6880<T>>> holderSet = this.shortcutLookup(tagKey);
        if (holderSet.isPresent()) {
            Iterable<class_6880<T>> data = holderSet.get();
            this.logger.debug(4, "%s - Shortcut lookup", tagKey);
            for (class_6880<T> holder : data) {
                Optional key = holder.method_40230();
                key.ifPresent(tResourceKey -> completeIds.add(tResourceKey.method_29177()));
            }
        } else {
            HashSet entries = new HashSet();
            IStopwatch stopwatch = this.systemClock.getStopwatch();
            Collection<class_7475> tagFiles = this.resourceUtilities.findClientTagFiles(tagKey);
            this.logger.debug(4, "[%s] Find client tags took %dmillis", tagKey, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            tagFiles.forEach(tf -> entries.addAll(tf.comp_811()));
            if (!entries.isEmpty()) {
                this.logger.debug(4, "%s - %d entries found", tagKey, entries.size());
                class_3497.class_7474<class_2960> lookup = new class_3497.class_7474<class_2960>(){

                    @NotNull
                    public class_2960 element(@NotNull class_2960 id) {
                        return id;
                    }

                    @Nullable
                    public Collection<class_2960> method_43949(@NotNull class_2960 id) {
                        class_6862 tag = class_6862.method_40092((class_5321)tagKey.comp_326(), (class_2960)id);
                        ClientTagLoader.this.logger.debug(4, "%s - Recurse %s", tagKey, tag);
                        Set<class_2960> result = ClientTagLoader.this.getTagData(tag, visited).members();
                        ClientTagLoader.this.logger.debug(4, "%s - Completed recursion %s", tagKey, tag);
                        return result;
                    }
                };
                for (class_3497 tagEntry : entries) {
                    tagEntry.method_26790((class_3497.class_7474)lookup, completeIds::add);
                }
            }
        }
        if (completeIds.isEmpty()) {
            this.logger.debug(4, "%s - Tag is empty", tagKey);
            return TagData.empty();
        }
        this.logger.debug(4, "%s - %d direct instances", tagKey, completeIds.size());
        return new TagData((Set<class_2960>)ImmutableSet.copyOf(completeIds));
    }

    private <T> Optional<Iterable<class_6880<T>>> shortcutLookup(class_6862<T> tagKey) {
        String namespace = tagKey.comp_327().method_12836();
        if (namespace.equals("dsurround")) {
            return Optional.empty();
        }
        if (this.serverType.isModded() || "minecraft".equals(namespace)) {
            Optional registry = RegistryUtils.getRegistry(tagKey.comp_326());
            if (registry.isEmpty()) {
                return Optional.empty();
            }
            Optional holderSet = registry.get().method_40266(tagKey);
            if (holderSet.isPresent()) {
                return Optional.of((Iterable)holderSet.get());
            }
            return Optional.of(ImmutableList.of());
        }
        return Optional.empty();
    }

    private record TagData<T>(Set<class_2960> members) {
        private static final TagData<?> EMPTY = new TagData((Set<class_2960>)ImmutableSet.of());

        public static <T> TagData<T> empty() {
            return TagData.cast(EMPTY);
        }

        public static <T> TagData<T> cast(TagData<?> tagData) {
            return tagData;
        }
    }
}

