/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import dev.architectury.platform.Platform;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.AbstractResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;

public class DiskResourceFinder
extends AbstractResourceFinder {
    private final Collection<Path> namespacesOnDisk = new ObjectArray<Path>();

    public DiskResourceFinder(IModLog logger, Path diskLocation) {
        super(logger);
        try (DirectoryStream<Path> directoryList = Files.newDirectoryStream(diskLocation, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            directoryList.forEach(p -> {
                String modNamespace = p.getFileName().toString();
                if (Platform.isModLoaded((String)modNamespace)) {
                    this.namespacesOnDisk.add((Path)p);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public <T> Collection<DiscoveredResource<T>> find(Codec<T> codec, String assetPath) {
        if (this.namespacesOnDisk.isEmpty()) {
            return ImmutableList.of();
        }
        ObjectArray result = new ObjectArray();
        Object fileName = assetPath;
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
        }
        for (Path path : this.namespacesOnDisk) {
            Path filePath = Paths.get(path.toString(), new String[]{fileName});
            if (!Files.exists(filePath, new LinkOption[0])) continue;
            this.logger.debug(4, "[%s] - Processing %s file from disk", assetPath, filePath.toString());
            String namespace = path.getFileName().toString();
            class_2960 location = class_2960.method_60655((String)namespace, (String)assetPath);
            try {
                String content = Files.readString(filePath);
                this.decode(location, content, codec).ifPresent(e -> result.add(new DiscoveredResource<Object>(namespace, e)));
                this.logger.debug(4, "[%s] - Completed decode of %s", assetPath, filePath);
            }
            catch (Throwable t) {
                this.logger.error(t, "[%s] Unable to read resource stream for path %s", assetPath, location);
            }
        }
        return result;
    }
}

