/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.mojang.serialization.Codec;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.AbstractResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;

public class ModConfigResourceFinder
extends AbstractResourceFinder {
    private final Map<class_2960, List<class_3298>> resources;

    public ModConfigResourceFinder(IModLog logger, class_3300 resourceManager, String configPath) {
        super(logger);
        this.resources = resourceManager.method_41265(configPath, location -> true);
    }

    @Override
    public <T> Collection<DiscoveredResource<T>> find(Codec<T> codec, String path) {
        if (!((String)path).endsWith(".json")) {
            path = (String)path + ".json";
        }
        ObjectArray result = new ObjectArray();
        for (Map.Entry<class_2960, List<class_3298>> kvp : this.resources.entrySet()) {
            String resourcePath = kvp.getKey().method_12832();
            if (!resourcePath.endsWith((String)path)) continue;
            this.logger.debug(4, "[%s] - Processing %s", resourcePath, kvp.getKey());
            for (class_3298 r : kvp.getValue()) {
                try {
                    InputStream inputStream = r.method_14482();
                    try {
                        byte[] assetBytes = inputStream.readAllBytes();
                        String assetString = new String(assetBytes, Charset.defaultCharset());
                        Optional<Object> entity = this.decode(kvp.getKey(), assetString, codec);
                        entity.ifPresent(e -> result.add(new DiscoveredResource<Object>(((class_2960)kvp.getKey()).method_12836(), e)));
                        this.logger.debug(4, "[%s] - Completed decode of %s", resourcePath, kvp.getKey());
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Throwable t) {
                    this.logger.error(t, "[%s] - Unable to read resource stream for path %s", resourcePath, kvp.getKey());
                }
            }
        }
        return result;
    }
}

