/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_3264;
import org.orecruncher.dsurround.lib.Library;

public class ResourceLookupHelper {
    private final class_3264 packType;
    private Collection<Path> rootPaths;

    public ResourceLookupHelper(class_3264 packType) {
        this.packType = packType;
        this.rootPaths = ImmutableList.of();
    }

    public void refresh() {
        this.rootPaths = this.getResourceRootPaths();
    }

    public Collection<Path> findResourcePaths(String fileNamePattern) {
        if (this.rootPaths.isEmpty()) {
            Library.LOGGER.warn("No root paths defined for ResourceLookupHelper", new Object[0]);
        }
        return this.rootPaths.stream().map(path -> this.findPath(fileNamePattern, (Path)path)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Optional<Path> findPath(String fileNamePattern, Path root) {
        Path path = root.resolve(fileNamePattern.replace("/", root.getFileSystem().getSeparator()));
        if (Files.exists(path, new LinkOption[0])) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    private Collection<Path> getResourceRootPaths() {
        String pathPrefix = this.packType.method_14413();
        return Platform.getMods().stream().map(mod -> ResourceLookupHelper.findPath(mod, pathPrefix)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private static Optional<Path> findPath(Mod container, String file) {
        for (Path root : container.getFilePaths()) {
            Path path = root.resolve(file.replace("/", root.getFileSystem().getSeparator()));
            if (!Files.exists(path, new LinkOption[0])) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }
}

