/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.mojang.serialization.Codec;
import java.util.Collection;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import net.minecraft.class_7924;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.resources.ClientResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.DiskResourceFinder;
import org.orecruncher.dsurround.lib.resources.ModConfigResourceFinder;
import org.orecruncher.dsurround.lib.resources.ServerResourceFinder;

public final class ResourceUtilities {
    private final ModConfigResourceFinder modConfigHelper;
    private final DiskResourceFinder diskResourceHelper;
    private final ClientResourceFinder resourceFinder;
    private final ServerResourceFinder packResourceFinder;

    ResourceUtilities(IModLog modLog, IMinecraftDirectories minecraftDirectories, class_3300 resourceManager) {
        this.modConfigHelper = new ModConfigResourceFinder(modLog, resourceManager, "dsconfigs");
        this.diskResourceHelper = new DiskResourceFinder(modLog, minecraftDirectories.getModDataDirectory());
        this.resourceFinder = new ClientResourceFinder(modLog, resourceManager);
        this.packResourceFinder = new ServerResourceFinder(modLog);
    }

    public <T> Collection<DiscoveredResource<T>> findModResources(Codec<T> codec, String assetPath) {
        ObjectArray<DiscoveredResource<DiscoveredResource<T>>> result = new ObjectArray<DiscoveredResource<DiscoveredResource<T>>>();
        result.addAll((Collection<DiscoveredResource<DiscoveredResource<T>>>)this.modConfigHelper.find(codec, assetPath));
        result.addAll((Collection<DiscoveredResource<DiscoveredResource<T>>>)this.diskResourceHelper.find(codec, assetPath));
        return result;
    }

    public <T> Collection<DiscoveredResource<T>> findResources(Codec<T> codec, String assetPath) {
        return this.resourceFinder.find(codec, assetPath);
    }

    public Collection<class_7475> findClientTagFiles(class_6862<?> tagKey) {
        ObjectArray result = new ObjectArray();
        String tagDir = class_7924.method_60916((class_5321)tagKey.comp_326());
        String tagFolder = "%s/%s".formatted(tagDir, tagKey.comp_327().method_12832());
        String tagFolderPack = "%s:%s".formatted(tagKey.comp_327().method_12836(), tagFolder);
        result.addAll(this.packResourceFinder.find(class_7475.field_39269, tagFolderPack));
        result.addAll(this.modConfigHelper.find(class_7475.field_39269, tagFolder));
        result.addAll(this.diskResourceHelper.find(class_7475.field_39269, tagFolder));
        return result.stream().map(DiscoveredResource::resourceContent).toList();
    }

    public static ResourceUtilities createForCurrentState() {
        return ResourceUtilities.createForResourceManager(GameUtils.getMC().method_1478());
    }

    public static ResourceUtilities createForResourceManager(class_3300 resourceManager) {
        IModLog logger = ContainerManager.resolve(IModLog.class);
        IMinecraftDirectories directories = ContainerManager.resolve(IMinecraftDirectories.class);
        return new ResourceUtilities(logger, directories, resourceManager);
    }
}

