/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.mojang.serialization.Codec;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.orecruncher.dsurround.eventing.ClientState;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.events.HandlerPriority;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.AbstractResourceFinder;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceLookupHelper;

public class ServerResourceFinder
extends AbstractResourceFinder {
    private static final ResourceLookupHelper lookupHelper = new ResourceLookupHelper(class_3264.field_14190);

    protected ServerResourceFinder(IModLog logger) {
        super(logger);
    }

    @Override
    public <T> Collection<DiscoveredResource<T>> find(Codec<T> codec, String assetPath) {
        ObjectArray results = new ObjectArray();
        class_2960 resource = class_2960.method_12829((String)assetPath);
        assert (resource != null);
        Object filePath = assetPath.replace(":", "/");
        if (!((String)filePath).endsWith(".json")) {
            filePath = (String)filePath + ".json";
        }
        for (Path path : lookupHelper.findResourcePaths((String)filePath)) {
            this.logger.debug(4, "[%s] - Processing %s", resource, path.toString());
            try {
                String content = Files.readString(path);
                this.decode(resource, content, codec).ifPresent(r -> results.add(new DiscoveredResource<Object>(resource.method_12836(), r)));
                this.logger.debug(4, "[%s] - Completed decode of %s", resource, path);
            }
            catch (Throwable t) {
                this.logger.error(t, "[%s] - Unable to read %s", resource, path.toString());
            }
        }
        return results;
    }

    static {
        ClientState.RESOURCE_RELOAD.register(rm -> lookupHelper.refresh(), HandlerPriority.VERY_HIGH);
    }
}

