/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Collection;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_9380;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scanner.ComplementsPointIterator;
import org.orecruncher.dsurround.lib.scanner.Cuboid;
import org.orecruncher.dsurround.lib.scanner.CuboidPointIterator;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.lib.scanner.Scanner;

public abstract class CuboidScanner
extends Scanner {
    protected boolean scanFinished = false;
    protected class_9380 activeCuboid;
    protected CuboidPointIterator fullRange;
    protected class_2338 lastPos = class_2338.field_10980;
    protected class_2960 lastReference = class_2960.method_60654((String)"dsurround:aintnothin");

    protected CuboidScanner(ScanContext locus, String name, int range) {
        super(locus, name, range);
    }

    protected class_2338[] getMinMaxPointsForVolume(class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_25504((class_2382)pos, -this.xRange, -this.yRange, -this.zRange);
        mutable.method_33098(this.locus.clampHeight(mutable.method_10264()));
        class_2338 min = mutable.method_10062();
        mutable.method_25504((class_2382)pos, this.xRange, this.yRange, this.zRange);
        mutable.method_33098(this.locus.clampHeight(mutable.method_10264()));
        class_2338 max = mutable.method_10062();
        return new class_2338[]{min, max};
    }

    protected class_9380 getVolumeFor(class_2338 pos) {
        class_2338[] points = this.getMinMaxPointsForVolume(pos);
        return Cuboid.of(points);
    }

    @Override
    protected void setRange(int range) {
        if (this.xRange != range || this.yRange != range || this.zRange != range) {
            super.setRange(range);
            this.resetFullScan();
        }
    }

    public void resetFullScan() {
        this.lastPos = this.locus.getScanCenter();
        this.lastReference = this.locus.getWorldReference();
        this.scanFinished = false;
        class_2338[] points = this.getMinMaxPointsForVolume(this.lastPos);
        this.activeCuboid = Cuboid.of(points);
        this.fullRange = new CuboidPointIterator(points);
    }

    @Override
    public void tick() {
        class_2338 playerPos = this.locus.getScanCenter();
        if (this.locus.isOutOfHeightLimit(playerPos.method_10264())) {
            this.fullRange = null;
        } else if (this.fullRange == null || this.locus.getWorldReference() != this.lastReference) {
            this.locus.getLogger().debug("[%s] full range reset", this.name);
            this.resetFullScan();
            super.tick();
        } else if (this.lastPos.equals((Object)playerPos)) {
            if (!this.scanFinished) {
                super.tick();
            }
        } else {
            class_9380 newVolume;
            class_9380 oldVolume = this.activeCuboid != null ? this.activeCuboid : this.getVolumeFor(this.lastPos);
            class_9380 intersect = Cuboid.intersection(oldVolume, newVolume = this.getVolumeFor(playerPos));
            if (intersect == null) {
                this.locus.getLogger().debug("[%s] no intersection: %s, %s", this.name, oldVolume.toString(), newVolume.toString());
                this.resetFullScan();
                super.tick();
            } else if (this.scanFinished) {
                this.lastPos = playerPos;
                this.activeCuboid = newVolume;
                this.updateScan(newVolume, oldVolume, intersect);
            } else {
                super.tick();
            }
        }
    }

    public boolean doBlockUnscan() {
        return false;
    }

    public void blockUnscan(class_1937 world, class_2680 state, class_2338 pos, IRandomizer rand) {
    }

    protected void updateScan(class_9380 newVolume, class_9380 oldVolume, class_9380 intersect) {
        class_2680 state;
        class_2338 point;
        class_1937 provider = this.locus.getWorld();
        if (this.doBlockUnscan()) {
            ComplementsPointIterator newOutOfRange = new ComplementsPointIterator(oldVolume, intersect);
            point = newOutOfRange.next();
            while (point != null) {
                if (!this.locus.isOutOfHeightLimit(point.method_10264())) {
                    state = provider.method_8320(point);
                    this.blockUnscan(provider, state, point, this.random);
                }
                point = newOutOfRange.next();
            }
        }
        ComplementsPointIterator newInRange = new ComplementsPointIterator(newVolume, intersect);
        point = newInRange.next();
        while (point != null) {
            if (!this.locus.isOutOfHeightLimit(point.method_10264())) {
                state = provider.method_8320(point);
                this.blockScan(provider, state, point, this.random);
            }
            point = newInRange.next();
        }
        this.scanFinished = true;
    }

    @Override
    @Nullable
    protected class_2338 nextPos(class_2338.class_2339 workingPos, IRandomizer rand) {
        class_2338 point;
        if (this.scanFinished) {
            return null;
        }
        int checked = 0;
        while ((point = this.fullRange.peek()) != null) {
            this.fullRange.next();
            if (!this.locus.isOutOfHeightLimit(point.method_10264())) {
                return point;
            }
            if (++checked < this.blocksPerTick) continue;
            return null;
        }
        this.scanFinished = true;
        return null;
    }

    public void onBlockUpdates(Collection<class_2338> positions) {
        if (!positions.isEmpty() && this.activeCuboid != null) {
            class_1937 world = this.locus.getWorld();
            positions.stream().filter(p -> this.activeCuboid.method_58244(p)).forEach(p -> {
                class_2680 state = world.method_8320(p);
                if (!Constants.BLOCKS_TO_IGNORE.contains(state.method_26204())) {
                    try {
                        this.blockScan(world, state, (class_2338)p, this.random);
                    }
                    catch (Throwable t) {
                        this.locus.getLogger().error(t, "onBlockUpdate() error %s for state %s", p.toString(), state.toString());
                    }
                }
            });
        }
    }
}

