/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Constants;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.lib.scanner.ScanContext;

public abstract class Scanner {
    private static final int MAX_BLOCKS_TICK = 6000;
    protected final String name;
    protected int xRange;
    protected int yRange;
    protected int zRange;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int blocksPerTick;
    protected int volume;
    protected final ScanContext locus;
    protected final IRandomizer random = Randomizer.current();
    protected final class_2338.class_2339 workingPos = new class_2338.class_2339();

    public Scanner(ScanContext locus, String name, int range) {
        this(locus, name, range, range, range);
    }

    public Scanner(ScanContext locus, String name, int xRange, int yRange, int zRange) {
        this.name = name;
        this.locus = locus;
        this.setRange(xRange, yRange, zRange);
    }

    protected void setRange(int range) {
        this.setRange(range, range, range);
    }

    protected void setRange(int xRange, int yRange, int zRange) {
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.xSize = xRange * 2 + 1;
        this.ySize = yRange * 2 + 1;
        this.zSize = zRange * 2 + 1;
        this.volume = this.xSize * this.ySize * this.zSize;
        this.blocksPerTick = Math.min(this.volume / 20, 6000);
    }

    public int getVolume() {
        return this.volume;
    }

    public abstract void blockScan(class_1937 var1, class_2680 var2, class_2338 var3, IRandomizer var4);

    public void tick() {
        class_2338 pos;
        class_1937 world = this.locus.getWorld();
        for (int count = 0; count < this.blocksPerTick && (pos = this.nextPos(this.workingPos, this.random)) != null; ++count) {
            class_2680 state = world.method_8320(pos);
            if (Constants.BLOCKS_TO_IGNORE.contains(state.method_26204())) continue;
            this.blockScan(world, state, pos, this.random);
        }
    }

    @Nullable
    protected abstract class_2338 nextPos(class_2338.class_2339 var1, IRandomizer var2);
}

