/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scripting;

import java.util.Optional;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.scripting.IVariableAccess;
import org.orecruncher.dsurround.lib.scripting.LibraryFunctions;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.lib.scripting.ScriptEngineLoader;
import org.orecruncher.dsurround.lib.scripting.VariableSet;

public final class ExecutionContext
implements IVariableAccess {
    private final IModLog logger;
    private final String contextName;
    private final ScriptEngine engine;
    private final ObjectArray<VariableSet<?>> variables = new ObjectArray(8);

    public ExecutionContext(String contextName, IModLog logger) {
        this.logger = logger;
        this.contextName = contextName;
        this.engine = ScriptEngineLoader.getEngine().orElseThrow(() -> new RuntimeException("Unable to load a JavaScript engine!"));
        this.put("lib", ContainerManager.resolve(LibraryFunctions.class));
        ScriptEngineFactory factory = this.engine.getFactory();
        this.logger.info("[%s] JavaScript engine: %s (%s)", this.contextName, factory.getEngineName(), factory.getEngineVersion());
    }

    @Override
    public void put(String name, @Nullable Object obj) {
        this.engine.put(name, obj);
    }

    public void add(VariableSet<?> varSet) {
        if (this.engine.get(varSet.getSetName()) != null) {
            throw new IllegalStateException(String.format("Variable set '%s' already defined!", varSet.getSetName()));
        }
        this.variables.add(varSet);
        this.put(varSet.getSetName(), varSet.getInterface());
    }

    public String getName() {
        return this.contextName;
    }

    public void update() {
        this.variables.forEach(s -> s.update(this));
    }

    public boolean check(Script script) {
        Optional<Object> result = this.eval(script);
        if (result.isPresent()) {
            return "true".equalsIgnoreCase(result.toString());
        }
        return false;
    }

    public Optional<Object> eval(Script script) {
        Optional<CompiledScript> cached = script.getCompiledScript();
        CompiledScript func = cached.orElseGet(() -> {
            CompiledScript compiled = this.makeFunction(script.asString());
            script.setCompiledScript(compiled);
            return compiled;
        });
        try {
            Object result = func.eval();
            return Optional.ofNullable(result);
        }
        catch (Throwable t) {
            this.logger.error(t, "Error execution script: %s", script.asString());
            return Optional.of("ERROR? " + t.getMessage());
        }
    }

    private CompiledScript makeFunction(String script) {
        String source = script + ";";
        try {
            return ((Compilable)((Object)this.engine)).compile(source);
        }
        catch (Throwable t) {
            this.logger.error(t, "Error compiling script: %s", source);
            return this.makeErrorFunction(t);
        }
    }

    private CompiledScript makeErrorFunction(Throwable t) {
        String s = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)t.getMessage()));
        return this.makeFunction(s);
    }
}

