/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scripting;

import dev.architectury.platform.Platform;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.di.Cacheable;
import org.orecruncher.dsurround.lib.system.ISystemClock;

@Cacheable
public final class LibraryFunctions {
    private final ISystemClock systemClock;

    public LibraryFunctions(ISystemClock systemClock) {
        this.systemClock = systemClock;
    }

    public Object iif(boolean flag, @Nullable Object trueResult, @Nullable Object falseResult) {
        return flag ? trueResult : falseResult;
    }

    public boolean match(String pattern, String subject) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(subject);
        return Pattern.matches(pattern, subject);
    }

    public boolean oneof(Object testee, Object ... possibles) {
        Objects.requireNonNull(testee);
        Objects.requireNonNull(possibles);
        for (Object obj : possibles) {
            if (!testee.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public boolean isModLoaded(String mod) {
        return Platform.isModLoaded((String)mod);
    }

    public boolean isCurrentDateInRangeOf(int month, int day, int dayRange) {
        try {
            LocalDate theNow = LocalDate.ofInstant(this.systemClock.getUtcNow(), ZoneOffset.UTC);
            LocalDate testDate = LocalDate.of(theNow.getYear(), month, day);
            LocalDate begin = theNow.minusDays(dayRange);
            if (begin.isAfter(testDate)) {
                return false;
            }
            LocalDate end = theNow.plusDays(dayRange);
            if (!end.isBefore(testDate)) {
                return true;
            }
            return !begin.isAfter(testDate = testDate.plusYears(1L)) && !end.isBefore(testDate);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

