/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.system;

import java.util.concurrent.TimeUnit;
import org.orecruncher.dsurround.lib.system.IStopwatch;
import org.orecruncher.dsurround.lib.system.ISystemClock;

final class Stopwatch
implements IStopwatch {
    private final ISystemClock _systemClock;
    private long _timeMark;

    Stopwatch(ISystemClock clock) {
        this._systemClock = clock;
        this.reset();
    }

    @Override
    public void reset() {
        this._timeMark = this._systemClock.getUtcNanosNow();
    }

    @Override
    public boolean isNew() {
        return this._timeMark == 0L;
    }

    @Override
    public long elapsed(TimeUnit timeUnit) {
        if (this.isNew()) {
            return 0L;
        }
        return timeUnit.convert(this._systemClock.getUtcNanosNow() - this._timeMark, TimeUnit.NANOSECONDS);
    }
}

