/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.threading;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_3532;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;

public final class Worker {
    private final String name;
    private final Runnable task;
    private final IModLog logger;
    private final int frequency;
    private final LoggingTimerEMA timeTrack;
    private final ScheduledExecutorService executorService;
    private volatile String diagnosticString;

    public Worker(String name, Runnable task, int frequencyMsecs, IModLog logger) {
        this.name = name;
        this.task = task;
        this.frequency = frequencyMsecs;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.timeTrack = new LoggingTimerEMA(this.name);
        this.logger = logger;
        this.diagnosticString = "";
    }

    private void run() {
        this.timeTrack.begin();
        try {
            this.task.run();
        }
        catch (Throwable t) {
            this.logger.error(t, "Error processing %s!", this.name);
        }
        this.timeTrack.end();
        long sleepTime = (long)this.frequency - this.timeTrack.getLastSampleMSecs();
        long idleTime = class_3532.method_53062((long)sleepTime, (long)0L, (long)Long.MAX_VALUE);
        String track = this.timeTrack.toString();
        Object diagText = "%s (idle for %dmsecs)".formatted(track, idleTime);
        if (sleepTime < 0L) {
            diagText = (String)diagText + "; running behind %dms".formatted(Math.abs(sleepTime));
        }
        this.diagnosticString = diagText;
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(this::run, 0L, this.frequency, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        try {
            if (!this.executorService.isShutdown()) {
                this.executorService.shutdown();
            }
        }
        catch (Throwable t) {
            this.logger.warn("Error stopping worker thread [%s]", this.name);
        }
    }

    public String getDiagnosticString() {
        return this.diagnosticString;
    }
}

