/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.audio;

import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5195;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.gui.sound.SoundToast;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.mixinutils.IMusicManager;
import org.orecruncher.dsurround.mixinutils.MixinHelpers;
import org.orecruncher.dsurround.sound.SoundMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1142.class})
public class MixinMusicManager
implements IMusicManager {
    @Shadow
    @Nullable
    private class_1113 field_5574;
    @Shadow
    private int field_5572;
    @Unique
    private boolean dsurround_pauseTicking;

    @Override
    public String dsurround_getDiagnosticText() {
        String playingSound = "Nothing playing";
        if (this.field_5574 != null) {
            playingSound = this.field_5574.method_4775().toString();
        }
        Object result = "Music Manager: %d (%s)".formatted(this.field_5572, playingSound);
        if (this.dsurround_pauseTicking) {
            result = (String)result + " (PAUSED)";
        }
        return result;
    }

    @Override
    public void dsurround_doCommand(String command) {
        if ("reset".equals(command)) {
            class_1142 self = (class_1142)this;
            self.method_4859();
            this.field_5572 = 100;
            this.dsurround_pauseTicking = false;
        } else if ("pause".equals(command)) {
            this.dsurround_setPaused(true);
        } else if ("unpause".equals(command)) {
            this.dsurround_setPaused(false);
        }
    }

    @Override
    public void dsurround_setPaused(boolean flag) {
        class_1142 self = (class_1142)this;
        if (flag) {
            MixinHelpers.LOGGER.info("Stopping MusicManager", new Object[0]);
            this.dsurround_pauseTicking = true;
            self.method_4859();
        } else {
            MixinHelpers.LOGGER.info("Starting MusicManager", new Object[0]);
            this.field_5572 = 100;
            this.dsurround_pauseTicking = false;
        }
    }

    @Override
    public class_2561 dsurround_whatsPlaying() {
        if (this.field_5574 == null) {
            return class_2561.method_43471((String)"dsurround.text.musicmanager.nothing");
        }
        SoundMetadata metaData = MixinHelpers.SOUND_LIBRARY.getSoundMetadata(this.field_5574.method_4775());
        if (metaData == null || class_2561.method_43473().equals((Object)metaData.getTitle())) {
            return class_2561.method_43470((String)this.field_5574.method_4775().toString());
        }
        class_5250 title = metaData.getTitle().method_27661().method_54663(ColorPalette.PUMPKIN_ORANGE.method_27716());
        class_5250 author = metaData.getCredits().get(0).author().method_27661().method_54663(ColorPalette.WHEAT.method_27716());
        return class_2561.method_43469((String)"dsurround.text.musicmanager.playing", (Object[])new Object[]{title, author, class_2561.method_54154((class_2960)this.field_5574.method_4775())});
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void dsurround_pauseTickCheck(CallbackInfo ci) {
        if (this.dsurround_pauseTicking) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying(Lnet/minecraft/sounds/Music;)V"}, at={@At(value="RETURN")})
    public void dsurround_startPlaying(class_5195 music, CallbackInfo ci) {
        if (MixinHelpers.soundOptions.displayToastMessagesForMusic) {
            SoundToast.create(music);
        }
    }
}

