/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.mixins.audio;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1146;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4225;
import net.minecraft.class_4235;
import org.orecruncher.dsurround.mixinutils.MixinHelpers;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.runtime.audio.SoundFXProcessor;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;
import org.orecruncher.dsurround.sound.SoundVolumeEvaluator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public abstract class MixinSoundEngine {
    @Final
    @Shadow
    private class_4225 field_18945;

    @Inject(method={"loadLibrary()V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/Library;init(Ljava/lang/String;Z)V", shift=At.Shift.AFTER)})
    public void dsurround_init(CallbackInfo ci) {
        AudioUtilities.initialize(this.field_18945);
    }

    @Inject(method={"destroy()V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/Library;cleanup()V", shift=At.Shift.BEFORE)})
    public void dsurround_deinit(CallbackInfo ci) {
        AudioUtilities.deinitialize(this.field_18945);
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void dsurround_onSoundPlay(class_1113 soundInstance, CallbackInfo ci, class_1146 weighedSoundEvents, class_2960 resourceLocation, class_1111 sound, float f, float g, class_3419 soundSource, float h, float i, class_1113.class_1114 attenuation, boolean bl, class_243 vec3, boolean bl2, boolean bl3, CompletableFuture<?> completableFuture, class_4235.class_4236 channelHandle) {
        try {
            SoundFXProcessor.onSoundPlay(soundInstance, channelHandle);
            AudioUtilities.onSoundPlay(soundInstance);
        }
        catch (Throwable t) {
            MixinHelpers.LOGGER.error(t, "Error in dsurround_onSoundPlay()!", new Object[0]);
        }
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dsurround_play(class_1113 sound, CallbackInfo ci) {
        try {
            if (SoundInstanceHandler.shouldBlockSoundPlay(sound)) {
                ci.cancel();
            }
            if (SoundInstanceHandler.remapSoundPlay(sound)) {
                ci.cancel();
            }
        }
        catch (Exception t) {
            MixinHelpers.LOGGER.error(t, "Error in dsurround_play()!", new Object[0]);
        }
    }

    @Inject(method={"calculateVolume(Lnet/minecraft/client/resources/sounds/SoundInstance;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void dsurround_calculateVolume(class_1113 soundInstance, CallbackInfoReturnable<Float> cir) {
        try {
            float result = SoundVolumeEvaluator.getAdjustedVolume(soundInstance);
            cir.setReturnValue((Object)Float.valueOf(result));
        }
        catch (Throwable ex) {
            MixinHelpers.LOGGER.debug(2, "Error calculating sound volume: %s", ex);
        }
    }

    @Redirect(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundEngine;calculateVolume(FLnet/minecraft/sounds/SoundSource;)F"))
    private float dsurround_playGetAdjustedVolume(class_1140 instance, float f, class_3419 soundSource, class_1113 sound) {
        try {
            return SoundVolumeEvaluator.getAdjustedVolume(sound);
        }
        catch (Throwable ex) {
            MixinHelpers.LOGGER.debug(2, "Error calculating sound volume: %s", ex);
            return this.callCalculateVolume(f, soundSource);
        }
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V")}, cancellable=true)
    private void dsurround_soundRangeCheck(class_1113 soundInstance, CallbackInfo ci) {
        if (MixinHelpers.soundSystemConfig.enableSoundPruning && !SoundInstanceHandler.inRange(AudioUtilities.getSoundListener().method_55585().comp_2165(), soundInstance, 4)) {
            MixinHelpers.LOGGER.debug(2, () -> "TOO FAR: " + AudioUtilities.debugString(soundInstance));
            ci.cancel();
        }
    }

    @Invoker
    public abstract float callCalculateVolume(float var1, class_3419 var2);
}

