/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.AssetLibraryEvent;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.effects.systems.RandomBlockEffectSystem;
import org.orecruncher.dsurround.effects.systems.SteamEffectSystem;
import org.orecruncher.dsurround.effects.systems.WaterfallEffectSystem;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.scanner.SystemsScanner;
import org.orecruncher.dsurround.sound.IAudioPlayer;

public class AreaBlockEffects
extends AbstractClientHandler {
    private final IBlockLibrary blockLibrary;
    private final IAudioPlayer audioPlayer;
    protected ScanContext locus;
    protected SystemsScanner effectSystems;
    protected int blockUpdateCount;
    private boolean isConnected = false;

    public AreaBlockEffects(IBlockLibrary blockLibrary, IAudioPlayer audioPlayer, Configuration config, IModLog logger) {
        super("Area Block Effects", config, logger);
        this.blockLibrary = blockLibrary;
        this.audioPlayer = audioPlayer;
        ClientEventHooks.BLOCK_UPDATE.register(this::blockUpdates);
        AssetLibraryEvent.RELOAD.register(this::clear);
    }

    @Override
    public void process(class_1657 player) {
        this.blockUpdateCount = 0;
        if (!this.isConnected || !GameUtils.isInGame()) {
            return;
        }
        if (this.effectSystems != null) {
            this.effectSystems.tick();
        }
    }

    @Override
    public void onConnect() {
        this.locus = new ScanContext(() -> (class_1937)GameUtils.getWorld().orElseThrow(), () -> GameUtils.getPlayer().orElseThrow().method_24515(), this.logger);
        this.effectSystems = new SystemsScanner(this.config, this.locus);
        this.effectSystems.addEffectSystem(new SteamEffectSystem(this.logger, this.config));
        this.effectSystems.addEffectSystem(new WaterfallEffectSystem(this.logger, this.config));
        this.effectSystems.addEffectSystem(new RandomBlockEffectSystem(this.logger, this.config, this.blockLibrary, this.audioPlayer, 16));
        this.effectSystems.addEffectSystem(new RandomBlockEffectSystem(this.logger, this.config, this.blockLibrary, this.audioPlayer, 32));
        this.isConnected = true;
    }

    @Override
    public void onDisconnect() {
        this.isConnected = false;
        this.locus = null;
        this.effectSystems = null;
    }

    private void clear(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        if (this.effectSystems != null && GameUtils.isInGame()) {
            this.effectSystems.resetFullScan();
        }
    }

    private void blockUpdates(Collection<class_2338> blockPositions) {
        this.blockUpdateCount = blockPositions.size();
        if (this.effectSystems != null && GameUtils.isInGame()) {
            this.effectSystems.onBlockUpdates(blockPositions);
        }
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        Collection<class_2561> panelText = event.getSectionText(CollectDiagnosticsEvent.Section.Systems);
        panelText.add((class_2561)class_2561.method_43470((String)"Block Updates: %d".formatted(this.blockUpdateCount)));
        if (this.effectSystems != null) {
            this.effectSystems.gatherDiagnostics(panelText);
        }
    }
}

