/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IEntityEffectLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.AbstractClientHandler;

public class EntityEffectHandler
extends AbstractClientHandler {
    private final IEntityEffectLibrary entityEffectLibrary;
    private int entityCount;
    private int entityEffectsTicked;

    public EntityEffectHandler(Configuration config, IEntityEffectLibrary entityEffectLibrary, IModLog logger) {
        super("EntityEffect Handler", config, logger);
        this.entityEffectLibrary = entityEffectLibrary;
    }

    private int effectRange() {
        return this.config.entityEffects.entityEffectRange;
    }

    private int scanRange() {
        int range = this.effectRange();
        return range + (range >> 1);
    }

    @Override
    public void process(class_1657 player) {
        class_1937 world = player.method_37908();
        this.entityCount = 0;
        this.entityEffectsTicked = 0;
        class_238 worldBox = class_238.method_29968((class_243)player.method_33571()).method_1014((double)this.scanRange());
        List loadedEntities = world.method_18467(class_1309.class, worldBox);
        for (class_1309 entity : loadedEntities) {
            ++this.entityCount;
            boolean hasInfo = this.entityEffectLibrary.doesEntityEffectInfoExist(entity);
            boolean inRange = entity.method_24516((class_1297)player, (double)this.effectRange());
            EntityEffectInfo info = null;
            if (!hasInfo && entity.method_5805()) {
                if (inRange) {
                    info = this.entityEffectLibrary.getEntityEffectInfo(entity);
                }
            } else if (hasInfo) {
                info = this.entityEffectLibrary.getEntityEffectInfo(entity);
            }
            if (info == null) continue;
            if (inRange && info.isAlive() && !entity.method_7325()) {
                if (info.isDefault()) continue;
                ++this.entityEffectsTicked;
                info.tick();
                continue;
            }
            info.deactivate();
            this.entityEffectLibrary.clearEntityEffectInfo(entity);
        }
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        event.add(CollectDiagnosticsEvent.Section.Systems, "Entity effects (range %d/%d): entities %d, ticked %d".formatted(this.effectRange(), this.scanRange(), this.entityCount, this.entityEffectsTicked));
    }
}

