/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_6854;
import net.minecraft.class_758;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.eventing.CollectDiagnosticsEvent;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.fog.HolisticFogRangeCalculator;

public class FogHandler
extends AbstractClientHandler {
    private final HolisticFogRangeCalculator fogCalculator;
    private class_758.class_7285 lastData;

    public FogHandler(Configuration config, IModLog logger) {
        super("Fog Handler", config, logger);
        this.fogCalculator = new HolisticFogRangeCalculator(logger, config.fogOptions);
        this.lastData = new class_758.class_7285(class_758.class_4596.field_20946);
        this.lastData.field_38341 = 192.0f;
        this.lastData.field_38340 = 192.0f;
        ClientEventHooks.FOG_RENDER_EVENT.register(this::renderFog);
    }

    @Override
    public void process(class_1657 player) {
        if (this.fogCalculator.enabled()) {
            this.fogCalculator.tick();
        }
    }

    @Override
    public void onDisconnect() {
        this.fogCalculator.disconnect();
    }

    private void renderFog(class_758.class_7285 data, float renderDistance, float partialTick) {
        if (this.fogCalculator.enabled()) {
            this.lastData = this.fogCalculator.render(data, renderDistance, partialTick);
            RenderSystem.setShaderFogStart((float)this.lastData.field_38340);
            RenderSystem.setShaderFogEnd((float)this.lastData.field_38341);
            RenderSystem.setShaderFogShape((class_6854)this.lastData.field_38342);
        } else {
            this.lastData = data;
        }
    }

    @Override
    protected void gatherDiagnostics(CollectDiagnosticsEvent event) {
        Object text = "Fog: %f/%f, %s, %s ".formatted(Float.valueOf(this.lastData.field_38340), Float.valueOf(this.lastData.field_38341), this.lastData.field_38342, this.lastData.field_38339);
        Optional<String> disabledText = this.fogCalculator.getDisabledText();
        if (disabledText.isPresent()) {
            text = (String)text + disabledText.get();
        }
        event.add(CollectDiagnosticsEvent.Section.Systems, (String)text);
    }
}

