/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.AbstractClientHandler;
import org.orecruncher.dsurround.processing.accents.FootstepAccents;
import org.orecruncher.dsurround.sound.IAudioPlayer;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class StepAccentGenerator
extends AbstractClientHandler {
    private final IAudioPlayer audioPlayer;
    private final FootstepAccents footstepAccents;
    private final ObjectArray<ISoundFactory> accents = new ObjectArray(4);

    public StepAccentGenerator(Configuration config, IAudioPlayer audioPlayer, FootstepAccents footstepAccents, IModLog logger) {
        super("Step Accent", config, logger);
        this.audioPlayer = audioPlayer;
        this.footstepAccents = footstepAccents;
        ClientEventHooks.ENTITY_STEP_EVENT.register(this::footStepGenerated);
    }

    protected void footStepGenerated(class_1297 entity, class_2338 blockPos, class_2680 blockState) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (living.method_5701() || living.method_7325()) {
                return;
            }
            this.accents.clear();
            this.footstepAccents.collect(living, blockPos, blockState, this.accents);
            this.accents.forEach(factory -> this.audioPlayer.play((class_1113)factory.attachToEntity((class_1297)living)));
        }
    }
}

