/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.accents;

import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.config.libraries.IItemLibrary;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.processing.accents.IFootstepAccentProvider;
import org.orecruncher.dsurround.sound.ISoundFactory;

class ArmorAccents
implements IFootstepAccentProvider {
    private final Configuration config;
    private final IItemLibrary itemLibrary;

    ArmorAccents(Configuration config, IItemLibrary itemLibrary) {
        this.config = config;
        this.itemLibrary = itemLibrary;
    }

    @Override
    public boolean isEnabled() {
        return this.config.footstepAccents.enableArmorAccents;
    }

    @Override
    public void collect(class_1309 entity, class_2338 pos, class_2680 posState, boolean isWaterLogged, ObjectArray<ISoundFactory> acoustics) {
        Optional<ISoundFactory> footAccent = this.itemLibrary.getEquipableStepAccentSound(entity.method_6118(class_1304.field_6166));
        footAccent.ifPresent(acoustics::add);
        Optional<ISoundFactory> legs = this.itemLibrary.getEquipableStepAccentSound(entity.method_6118(class_1304.field_6172));
        legs.ifPresentOrElse(acoustics::add, () -> {
            Optional<ISoundFactory> chest = this.itemLibrary.getEquipableStepAccentSound(entity.method_6118(class_1304.field_6174));
            chest.ifPresent(acoustics::add);
        });
    }
}

